/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public final class GrowPulseCommand
extends SubCommand {
    private static final String NUMBER = "number";
    private static final Collection<String> NUMBER_SUGGESTIONS = Stream.of(1, 4, 8, 16, 32, 64).map(String::valueOf).collect(Collectors.toList());

    @Override
    protected String getName() {
        return "growpulse";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSource, ?> registerArgument() {
        return ((RequiredArgumentBuilder)GrowPulseCommand.blockPosArgument().executes(context -> GrowPulseCommand.executesSuccess(() -> this.sendGrowPulse((CommandSource)context.getSource(), GrowPulseCommand.rootPosArgument((CommandContext<CommandSource>)context), 1)))).then(Commands.func_197056_a((String)NUMBER, (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((context, builder) -> ISuggestionProvider.func_197005_b(NUMBER_SUGGESTIONS, (SuggestionsBuilder)builder)).executes(context -> GrowPulseCommand.executesSuccess(() -> this.sendGrowPulse((CommandSource)context.getSource(), GrowPulseCommand.rootPosArgument((CommandContext<CommandSource>)context), GrowPulseCommand.intArgument((CommandContext<CommandSource>)context, NUMBER)))));
    }

    private void sendGrowPulse(CommandSource source, BlockPos rootPos, int number) {
        for (int i = 0; i < number; ++i) {
            TreeHelper.growPulse((World)source.func_197023_e(), rootPos);
        }
        GrowPulseCommand.sendSuccessAndLog(source, (ITextComponent)new TranslationTextComponent("commands.dynamictrees.success.grow_pulse", new Object[]{CommandHelper.colour(String.valueOf(number), TextFormatting.AQUA), CommandHelper.posComponent((Vector3i)rootPos, TextFormatting.AQUA)}));
    }
}

