/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.awt.Color;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.TranslationTextComponent;

public final class HexColorArgument
implements ArgumentType<Integer> {
    public static final DynamicCommandExceptionType COLOR_INVALID = new DynamicCommandExceptionType(colourString -> new TranslationTextComponent("argument.color.invalid", new Object[]{colourString}));

    public static HexColorArgument hex() {
        return new HexColorArgument();
    }

    public static int getHexCode(CommandContext<?> context, String name) {
        return (Integer)context.getArgument(name, Integer.class);
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        int colour;
        String in = reader.readString();
        try {
            colour = Color.decode((in.startsWith("#") ? "" : "#") + in).getRGB();
        }
        catch (NumberFormatException e) {
            throw COLOR_INVALID.create((Object)in);
        }
        return colour;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197005_b(Collections.singletonList("00FFFF"), (SuggestionsBuilder)builder);
    }
}

