/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.compat.waila.WailaOther;
import com.ferreusveritas.dynamictrees.systems.nodemappers.TransformNode;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class TransformCommand
extends SubCommand {
    private static final Dynamic2CommandExceptionType SPECIES_EQUAL = new Dynamic2CommandExceptionType((toSpecies, fromSpecies) -> new TranslationTextComponent("commands.dynamictrees.error.species_equal", new Object[]{TransformCommand.darkRed(toSpecies), TransformCommand.darkRed(fromSpecies)}));

    @Override
    protected String getName() {
        return "transform";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSource, ?> registerArgument() {
        return TransformCommand.blockPosArgument().then(TransformCommand.transformableSpeciesArgument().executes(context -> TransformCommand.executesSuccess(() -> this.transformSpecies((CommandSource)context.getSource(), TransformCommand.rootPosArgument((CommandContext<CommandSource>)context), TransformCommand.speciesArgument((CommandContext<CommandSource>)context)))));
    }

    private void transformSpecies(CommandSource source, BlockPos rootPos, Species toSpecies) throws CommandSyntaxException {
        ServerWorld world = source.func_197023_e();
        Species fromSpecies = TreeHelper.getExactSpecies((World)world, rootPos);
        if (toSpecies == fromSpecies) {
            throw SPECIES_EQUAL.create((Object)toSpecies.getTextComponent(), (Object)fromSpecies.getTextComponent());
        }
        if (!toSpecies.isTransformable() || !fromSpecies.isTransformable()) {
            throw SPECIES_NOT_TRANSFORMABLE.create((Object)(!toSpecies.isTransformable() ? toSpecies.getTextComponent() : fromSpecies.getTextComponent()));
        }
        BlockState rootyState = world.func_180495_p(rootPos);
        RootyBlock rootyBlock = (RootyBlock)rootyState.func_177230_c();
        rootyBlock.startAnalysis((IWorld)world, rootPos, new MapSignal(new TransformNode(fromSpecies, toSpecies)));
        if (rootyBlock.getSpecies(rootyState, (IWorld)world, rootPos) != toSpecies) {
            toSpecies.placeRootyDirtBlock((IWorld)world, rootPos, rootyBlock.getFertility(rootyState, (IBlockReader)world, rootPos));
        }
        TransformCommand.sendSuccessAndLog(source, (ITextComponent)new TranslationTextComponent("commands.dynamictrees.success.transform", new Object[]{fromSpecies.getTextComponent(), CommandHelper.posComponent((Vector3i)rootPos, TextFormatting.AQUA), toSpecies.getTextComponent()}));
        WailaOther.invalidateWailaPosition();
    }
}

