/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat.seasons;

import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class FlowerHoldPeriod {
    public static final Codec<FlowerHoldPeriod> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("start").forGetter(FlowerHoldPeriod::getStart), (App)Codec.FLOAT.fieldOf("end").forGetter(FlowerHoldPeriod::getEnd)).apply((Applicative)instance, FlowerHoldPeriod::new));
    private final float start;
    private final float end;

    public FlowerHoldPeriod(float start, float end) {
        this.start = start;
        this.end = end;
    }

    float getStart() {
        return this.start;
    }

    float getEnd() {
        return this.end;
    }

    public boolean isIn(Float seasonValue, Float fruitingOffset) {
        return SeasonHelper.isSeasonBetween(seasonValue, this.start + fruitingOffset.floatValue(), this.end + fruitingOffset.floatValue());
    }
}

