/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat.seasons;

import com.ferreusveritas.dynamictrees.api.seasons.SeasonManager;
import com.ferreusveritas.dynamictrees.compat.seasons.NormalSeasonManager;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SeasonHelper {
    public static final float SPRING = 0.0f;
    public static final float SUMMER = 1.0f;
    public static final float AUTUMN = 2.0f;
    public static final float WINTER = 3.0f;
    public static final float FULL_SEASON = 1.0f;
    public static final float HALF_SEASON = 1.0f;
    public static final float DRY = 1.0f;
    public static final float WET = 3.0f;
    private static SeasonManager seasonManager = NormalSeasonManager.NULL.get();

    public static SeasonManager getSeasonManager() {
        return seasonManager;
    }

    public static void setSeasonManager(SeasonManager manager) {
        seasonManager = manager;
    }

    public static void updateTick(World world, long worldTicks) {
        seasonManager.updateTick(world, worldTicks);
    }

    public static float globalSeasonalGrowthFactor(WorldContext worldContext, BlockPos rootPos) {
        return SeasonHelper.globalSeasonalGrowthFactor(worldContext, rootPos, 0.0f);
    }

    public static float globalSeasonalGrowthFactor(WorldContext worldContext, BlockPos rootPos, float offset) {
        return (Boolean)DTConfigs.ENABLE_SEASONAL_GROWTH_FACTOR.get() != false ? seasonManager.getGrowthFactor(worldContext.level(), rootPos, offset) : 1.0f;
    }

    public static float globalSeasonalSeedDropFactor(WorldContext worldContext, BlockPos pos) {
        return SeasonHelper.globalSeasonalSeedDropFactor(worldContext, pos, 0.0f);
    }

    public static float globalSeasonalSeedDropFactor(WorldContext worldContext, BlockPos pos, float offset) {
        return (Boolean)DTConfigs.ENABLE_SEASONAL_SEED_DROP_FACTOR.get() != false ? seasonManager.getSeedDropFactor(worldContext.level(), pos, offset) : 1.0f;
    }

    public static float globalSeasonalFruitProductionFactor(WorldContext worldContext, BlockPos pos, boolean getAsScan) {
        return SeasonHelper.globalSeasonalFruitProductionFactor(worldContext, pos, 0.0f, getAsScan);
    }

    public static float globalSeasonalFruitProductionFactor(WorldContext worldContext, BlockPos pos, float offset, boolean getAsScan) {
        return (Boolean)DTConfigs.ENABLE_SEASONAL_FRUIT_PRODUCTION_FACTOR.get() != false ? seasonManager.getFruitProductionFactor(worldContext.level(), pos, offset, getAsScan) : 1.0f;
    }

    public static Float getSeasonValue(IWorld world, BlockPos pos) {
        return SeasonHelper.getSeasonValue(WorldContext.create(world), pos);
    }

    public static Float getSeasonValue(WorldContext worldContext, BlockPos pos) {
        return seasonManager.getSeasonValue(worldContext.level(), pos);
    }

    public static boolean isTropical(World world, BlockPos pos) {
        return seasonManager.isTropical((IWorld)world, pos);
    }

    public static boolean isSeasonBetween(Float testValue, float SeasonA, float SeasonB) {
        testValue = Float.valueOf(testValue.floatValue() % 4.0f);
        if ((SeasonA %= 4.0f) <= (SeasonB %= 4.0f)) {
            return testValue.floatValue() > SeasonA && testValue.floatValue() < SeasonB;
        }
        return testValue.floatValue() < SeasonB || testValue.floatValue() > SeasonA;
    }

    public static boolean shouldSnowMelt(World world, BlockPos pos) {
        return seasonManager.shouldSnowMelt(world, pos);
    }
}

