/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.compat.waila;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.compat.waila.WailaOther;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NetVolumeNode;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.LinkedList;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.RenderableTextComponent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class WailaBranchHandler
implements IComponentProvider {
    private BlockPos lastPos = BlockPos.field_177992_a;
    private Species lastSpecies = Species.NULL_SPECIES;
    private NetVolumeNode.Volume lastVolume = new NetVolumeNode.Volume();

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (WailaOther.invalid) {
            this.lastPos = BlockPos.field_177992_a;
            this.lastSpecies = Species.NULL_SPECIES;
            this.lastVolume = new NetVolumeNode.Volume();
            WailaOther.invalid = false;
        }
        CompoundNBT nbtData = accessor.getServerData();
        BlockPos pos = accessor.getPosition();
        Species species = Species.NULL_SPECIES;
        if (nbtData.func_74764_b("species")) {
            species = TreeRegistry.findSpecies(new ResourceLocation(nbtData.func_74779_i("species")));
        }
        if (species == Species.NULL_SPECIES && this.lastPos.equals((Object)pos)) {
            species = this.lastSpecies;
        }
        if (species == Species.NULL_SPECIES) {
            species = this.getWailaSpecies(accessor.getWorld(), pos);
        }
        if (!species.useDefaultWailaBody()) {
            return;
        }
        if (!this.lastPos.equals((Object)pos)) {
            this.lastVolume = this.getTreeVolume(accessor.getWorld(), pos);
        }
        this.lastSpecies = species;
        this.lastPos = pos;
        if (species != Species.NULL_SPECIES) {
            if (species.showSpeciesOnWaila()) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.dynamictrees.species", new Object[]{species.getTextComponent()}));
            }
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_GRAY + species.getRegistryName().toString()));
            }
            ItemStack seedStack = species.getSeedStack(1);
            LinkedList<RenderableTextComponent> renderers = new LinkedList<RenderableTextComponent>();
            renderers.add(WailaBranchHandler.getRenderable(seedStack));
            if (this.lastVolume.getVolume() > 0.0f) {
                ItemStack stickStack;
                Species.LogsAndSticks las = species.getLogsAndSticks(this.lastVolume);
                List<ItemStack> logStacks = las.logs;
                if (!logStacks.isEmpty()) {
                    for (ItemStack logStack : logStacks) {
                        renderers.add(WailaBranchHandler.getRenderable(logStack));
                    }
                }
                if (las.sticks > 0 && !(stickStack = species.getFamily().getStick(las.sticks)).func_190926_b()) {
                    renderers.add(WailaBranchHandler.getRenderable(stickStack));
                }
            }
            RenderableTextComponent renderables = new RenderableTextComponent(renderers.toArray(new RenderableTextComponent[0]));
            tooltip.add((ITextComponent)renderables);
        }
    }

    private NetVolumeNode.Volume getTreeVolume(World world, BlockPos pos) {
        TrunkShellBlock.ShellMuse muse;
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof TrunkShellBlock && (muse = ((TrunkShellBlock)block).getMuse((IBlockReader)world, pos)) != null) {
            state = muse.state;
            block = state.func_177230_c();
            pos = muse.pos;
        }
        if (block instanceof BranchBlock) {
            BranchBlock branch = (BranchBlock)block;
            NetVolumeNode volumeSum = new NetVolumeNode();
            branch.analyse(state, (IWorld)world, pos, null, new MapSignal(volumeSum));
            NetVolumeNode.Volume volume = volumeSum.getVolume();
            volume.multiplyVolume((Double)DTConfigs.TREE_HARVEST_MULTIPLIER.get());
            return volume;
        }
        return new NetVolumeNode.Volume();
    }

    private Species getWailaSpecies(World world, BlockPos pos) {
        return TreeHelper.getBestGuessSpecies(world, pos);
    }

    private static RenderableTextComponent getRenderable(ItemStack stack) {
        CompoundNBT tag = new CompoundNBT();
        if (!stack.func_190926_b()) {
            tag.func_74778_a("id", stack.func_77973_b().getRegistryName().toString());
            tag.func_74768_a("count", stack.func_190916_E());
            if (stack.func_77942_o()) {
                tag.func_74778_a("nbt", stack.func_77978_p().toString());
            }
            return new RenderableTextComponent(new ResourceLocation("item"), tag);
        }
        tag.func_74768_a("width", 0);
        return new RenderableTextComponent(new ResourceLocation("spacer"), tag);
    }
}

