/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.data;

import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;

public final class DTRecipes {
    public static void registerDirtBucketRecipes(Map<ResourceLocation, IRecipe<?>> craftingRecipes) {
        for (Species species : Species.REGISTRY.getAll()) {
            if (!species.hasSeed()) continue;
            ResourceLocation registryName = species.getRegistryName();
            species.getPrimitiveSaplingRecipes().forEach(saplingRecipe -> {
                List<Item> ingredients;
                Item saplingItem = saplingRecipe.getSaplingItem().orElse(null);
                if (saplingItem == null || saplingItem.getRegistryName() == null) {
                    LogManager.getLogger().error("Error creating seed-sapling recipe for species \"" + species.getRegistryName() + "\" as sapling item does not exist.");
                    return;
                }
                if (saplingRecipe.canCraftSaplingToSeed()) {
                    ResourceLocation saplingToSeed = new ResourceLocation(registryName.func_110624_b(), DTRecipes.separate(saplingItem.getRegistryName()) + "_to_" + registryName.func_110623_a() + "_seed");
                    ingredients = saplingRecipe.getIngredientsForSaplingToSeed();
                    ingredients.add(DTRegistries.DIRT_BUCKET);
                    ingredients.add(saplingItem);
                    craftingRecipes.putIfAbsent(saplingToSeed, (IRecipe<?>)DTRecipes.createShapeless(saplingToSeed, species.getSeedStack(1), DTRecipes.ingredients(ingredients)));
                }
                if (saplingRecipe.canCraftSeedToSapling()) {
                    ResourceLocation seedToSapling = new ResourceLocation(registryName.func_110624_b(), registryName.func_110623_a() + "_seed_to_" + DTRecipes.separate(saplingItem.getRegistryName()));
                    ingredients = saplingRecipe.getIngredientsForSeedToSapling();
                    ingredients.add(DTRegistries.DIRT_BUCKET);
                    ingredients.add(species.getSeed().map(Item.class::cast).orElse(Items.field_190931_a));
                    craftingRecipes.putIfAbsent(seedToSapling, (IRecipe<?>)DTRecipes.createShapeless(seedToSapling, new ItemStack((IItemProvider)saplingItem), DTRecipes.ingredients(ingredients)));
                }
            });
        }
    }

    private static String separate(ResourceLocation resourceLocation) {
        return resourceLocation.func_110624_b() + "_" + resourceLocation.func_110623_a();
    }

    private static ShapelessRecipe createShapeless(ResourceLocation registryName, ItemStack out, Ingredient ... ingredients) {
        return new ShapelessRecipe(registryName, "CRAFTING_MISC", out, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients));
    }

    private static Ingredient[] ingredients(Collection<Item> items) {
        return DTRecipes.ingredients(items.toArray(new Item[0]));
    }

    private static Ingredient[] ingredients(Item ... items) {
        if (items.length == 0) {
            return new Ingredient[]{Ingredient.field_193370_a};
        }
        return Arrays.stream(items).map(item -> Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)item)})).collect(Collectors.toSet()).toArray(new Ingredient[0]);
    }
}

