/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.data.provider;

import com.ferreusveritas.dynamictrees.event.handlers.BakedModelEventHandler;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public final class BranchLoaderBuilder
extends CustomLoaderBuilder<BlockModelBuilder> {
    private final Map<String, String> textures = new LinkedHashMap<String, String>();

    public BranchLoaderBuilder(ResourceLocation loaderId, BlockModelBuilder parent, ExistingFileHelper existingFileHelper) {
        super(loaderId, (ModelBuilder)parent, existingFileHelper);
    }

    public BranchLoaderBuilder texture(String key, ResourceLocation location) {
        this.textures.put(key, location.toString());
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        JsonObject textures = new JsonObject();
        this.textures.forEach((key, location) -> textures.add(key, (JsonElement)new JsonPrimitive(location)));
        json.add("textures", (JsonElement)textures);
        return json;
    }

    public static BranchLoaderBuilder branch(BlockModelBuilder parent, ExistingFileHelper existingFileHelper) {
        return new BranchLoaderBuilder(BakedModelEventHandler.BRANCH, parent, existingFileHelper);
    }

    public static BranchLoaderBuilder root(BlockModelBuilder parent, ExistingFileHelper existingFileHelper) {
        return new BranchLoaderBuilder(BakedModelEventHandler.ROOT, parent, existingFileHelper);
    }
}

