/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.data.provider;

import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.loot.condition.SeasonalSeedDropChance;
import com.ferreusveritas.dynamictrees.loot.condition.VoluntarySeedDropChance;
import com.ferreusveritas.dynamictrees.loot.entry.SeedItemLootEntry;
import com.ferreusveritas.dynamictrees.loot.function.MultiplyLogsCount;
import com.ferreusveritas.dynamictrees.loot.function.MultiplySticksCount;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DTLootTableProvider
extends LootTableProvider {
    private static final ILootCondition.IBuilder HAS_SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
    private static final ILootCondition.IBuilder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.func_216298_a();
    private static final ILootCondition.IBuilder HAS_SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ));
    private static final ILootCondition.IBuilder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.func_216297_a(HAS_SILK_TOUCH);
    private static final ILootCondition.IBuilder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.func_216298_a();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<ResourceLocation, LootTable.Builder> lootTables = new HashMap<ResourceLocation, LootTable.Builder>();
    private final DataGenerator generator;
    private final String modId;
    private final ExistingFileHelper existingFileHelper;

    public DTLootTableProvider(DataGenerator generator, String modId, ExistingFileHelper existingFileHelper) {
        super(generator);
        this.generator = generator;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addTables();
        this.writeTables(cache);
    }

    private void addTables() {
        Species.REGISTRY.dataGenerationStream(this.modId).forEach(this::addVoluntaryTable);
        ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof BranchBlock).map(block -> (BranchBlock)block).filter(block -> block.getRegistryName().func_110624_b().equals(this.modId)).forEach(this::addBranchTable);
        LeavesProperties.REGISTRY.dataGenerationStream(this.modId).forEach(leavesProperties -> {
            this.addLeavesBlockTable((LeavesProperties)leavesProperties);
            this.addLeavesTable((LeavesProperties)leavesProperties);
        });
        Fruit.REGISTRY.dataGenerationStream(this.modId).forEach(this::addFruitBlockTable);
        Pod.REGISTRY.dataGenerationStream(this.modId).forEach(this::addPodBlockTable);
    }

    private void addVoluntaryTable(Species species) {
        ResourceLocation leavesTablePath;
        if (species.shouldGenerateVoluntaryDrops() && !this.existingFileHelper.exists(leavesTablePath = this.getFullDropsPath(species.getVoluntaryDropsPath()), ResourcePackType.SERVER_DATA)) {
            this.lootTables.put(leavesTablePath, species.createVoluntaryDrops());
        }
    }

    private void addBranchTable(BranchBlock branchBlock) {
        ResourceLocation branchTablePath;
        if (branchBlock.shouldGenerateBranchDrops() && !this.existingFileHelper.exists(branchTablePath = this.getFullDropsPath(branchBlock.getLootTableName()), ResourcePackType.SERVER_DATA)) {
            this.lootTables.put(branchTablePath, branchBlock.createBranchDrops());
        }
    }

    private void addLeavesBlockTable(LeavesProperties leavesProperties) {
        ResourceLocation leavesBlockTablePath;
        if (leavesProperties.shouldGenerateBlockDrops() && !this.existingFileHelper.exists(leavesBlockTablePath = this.getFullDropsPath(leavesProperties.getBlockLootTableName()), ResourcePackType.SERVER_DATA)) {
            this.lootTables.put(leavesBlockTablePath, leavesProperties.createBlockDrops());
        }
    }

    private void addLeavesTable(LeavesProperties leavesProperties) {
        ResourceLocation leavesTablePath;
        if (leavesProperties.shouldGenerateDrops() && !this.existingFileHelper.exists(leavesTablePath = this.getFullDropsPath(leavesProperties.getLootTableName()), ResourcePackType.SERVER_DATA)) {
            this.lootTables.put(leavesTablePath, leavesProperties.createDrops());
        }
    }

    private void addFruitBlockTable(Fruit fruit) {
        ResourceLocation fruitBlockTablePath;
        if (fruit.shouldGenerateBlockDrops() && !this.existingFileHelper.exists(fruitBlockTablePath = this.getFullDropsPath(fruit.getBlockDropsPath()), ResourcePackType.SERVER_DATA)) {
            this.lootTables.put(fruitBlockTablePath, fruit.createBlockDrops());
        }
    }

    private void addPodBlockTable(Pod pod) {
        ResourceLocation fruitBlockTablePath;
        if (pod.shouldGenerateBlockDrops() && !this.existingFileHelper.exists(fruitBlockTablePath = this.getFullDropsPath(pod.getBlockDropsPath()), ResourcePackType.SERVER_DATA)) {
            this.lootTables.put(fruitBlockTablePath, pod.createBlockDrops());
        }
    }

    private ResourceLocation getFullDropsPath(ResourceLocation path) {
        return ResourceLocationUtils.surround(path, "loot_tables/", ".json");
    }

    public static LootTable.Builder createLeavesBlockDrops(Block primitiveLeavesBlock, float[] seedChances) {
        return BlockLootTables.func_218535_c((Block)primitiveLeavesBlock, (LootEntry.Builder)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)SeedItemLootEntry.lootTableSeedItem().func_212840_b_(SurvivesExplosion.func_215968_b())).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])seedChances))).func_212840_b_(SeasonalSeedDropChance.seasonalSeedDropChance())).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(HAS_NO_SHEARS_OR_SILK_TOUCH).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_151055_y).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))).func_216039_a(LootParameterSets.field_216267_h);
    }

    public static LootTable.Builder createPalmLeavesBlockDrops(Block primitiveLeavesBlock, float[] seedChances) {
        return BlockLootTables.func_218535_c((Block)primitiveLeavesBlock, (LootEntry.Builder)((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)SeedItemLootEntry.lootTableSeedItem().func_212840_b_(SurvivesExplosion.func_215968_b())).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])seedChances))).func_212840_b_(SeasonalSeedDropChance.seasonalSeedDropChance())).func_216039_a(LootParameterSets.field_216267_h);
    }

    public static LootTable.Builder createWartBlockDrops(Block primitiveWartBlock) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)primitiveWartBlock)).func_212840_b_(SurvivesExplosion.func_215968_b()));
    }

    public static LootTable.Builder createLeavesDrops(float[] seedChances, LootParameterSet parameterSet) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)SeedItemLootEntry.lootTableSeedItem().func_212840_b_(SurvivesExplosion.func_215968_b())).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])seedChances))).func_212840_b_(SeasonalSeedDropChance.seasonalSeedDropChance()))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)Items.field_151055_y).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))).func_216039_a(parameterSet);
    }

    public static LootTable.Builder createPalmLeavesDrops(float[] seedChances, LootParameterSet parameterSet) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(((StandaloneLootEntry.Builder)((StandaloneLootEntry.Builder)SeedItemLootEntry.lootTableSeedItem().func_212840_b_(SurvivesExplosion.func_215968_b())).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])seedChances))).func_212840_b_(SeasonalSeedDropChance.seasonalSeedDropChance()))).func_216039_a(parameterSet);
    }

    public static LootTable.Builder createWartDrops(Block primitiveWartBlock) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)primitiveWartBlock)).func_212840_b_(SurvivesExplosion.func_215968_b()).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.1f, 0.1333333f, 0.1666666f, 0.2f})));
    }

    public static LootTable.Builder createVoluntaryDrops(Item seedItem) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)seedItem).func_212840_b_(VoluntarySeedDropChance.voluntarySeedDropChance()))).func_216039_a(DTLootParameterSets.VOLUNTARY);
    }

    public static LootTable.Builder createBranchDrops(Block primitiveLogBlock, Item stickItem) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)primitiveLogBlock).func_212841_b_(MultiplyLogsCount.multiplyLogsCount()).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)stickItem).func_212841_b_(MultiplySticksCount.multiplySticksCount()).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()))).func_216039_a(DTLootParameterSets.BRANCHES);
    }

    public static LootTable.Builder createFruitDrops(Block fruitBlock, Item fruitItem, IntegerProperty ageProperty, int matureAge) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)fruitItem).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)fruitBlock).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)ageProperty, matureAge))))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()).func_216039_a(LootParameterSets.field_216267_h);
    }

    public static LootTable.Builder createPodDrops(Block podBlock, Item podItem, IntegerProperty ageProperty, int matureAge) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)podItem).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)3)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)podBlock).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)ageProperty, matureAge)))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()))).func_216039_a(LootParameterSets.field_216267_h);
    }

    private void writeTables(DirectoryCache cache) {
        Path outputFolder = this.generator.func_200391_b();
        this.lootTables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/" + key.func_110623_a());
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable.func_216038_b()), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }

    public String func_200397_b() {
        return this.modId;
    }
}

