/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.api.treepacks.VoidApplier;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonPropertyAppliers;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.ferreusveritas.dynamictrees.util.BiomeList;
import com.ferreusveritas.dynamictrees.util.JsonMapWrapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BiomeListDeserialiser
implements JsonDeserialiser<BiomeList> {
    private static final VoidApplier<BiomeList, String> TYPE_APPLIER = (biomeList, typeRegex) -> {
        boolean notOperator = BiomeListDeserialiser.usingNotOperator(typeRegex);
        typeRegex = typeRegex.toLowerCase();
        if (notOperator) {
            typeRegex = typeRegex.substring(1);
            BiomeListDeserialiser.removeBiomesWithMatchingType(biomeList, typeRegex);
        } else {
            BiomeListDeserialiser.removeBiomesWithoutMatchingType(biomeList, typeRegex);
        }
    };
    private static final VoidApplier<BiomeList, String> CATEGORY_APPLIER = (biomeList, categoryRegex) -> {
        boolean notOperator = BiomeListDeserialiser.usingNotOperator(categoryRegex);
        if (notOperator) {
            categoryRegex = categoryRegex.substring(1);
            BiomeListDeserialiser.removeBiomesWithMatchingCategory(biomeList, categoryRegex);
        } else {
            BiomeListDeserialiser.removeBiomesWithoutMatchingCategory(biomeList, categoryRegex);
        }
    };
    private static final VoidApplier<BiomeList, String> NAME_APPLIER = (biomeList, nameRegex) -> {
        boolean notOperator = BiomeListDeserialiser.usingNotOperator(nameRegex);
        nameRegex = nameRegex.toLowerCase();
        if (notOperator) {
            nameRegex = nameRegex.substring(1);
            BiomeListDeserialiser.removeBiomesWithMatchingName(biomeList, nameRegex);
        } else {
            BiomeListDeserialiser.removeBiomesWithoutMatchingName(biomeList, nameRegex);
        }
    };
    private static final VoidApplier<BiomeList, JsonArray> NAMES_OR_APPLIER = (biomeList, json) -> {
        List<String> nameRegexes = JsonResult.forInput((JsonElement)json).mapEachIfArray(String.class, String::toLowerCase).orElse(Collections.emptyList(), arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0), arg_0 -> ((Logger)LogManager.getLogger()).warn(arg_0));
        BiomeList validBiomes = new BiomeList();
        nameRegexes.forEach(nameRegex -> {
            if (BiomeListDeserialiser.usingNotOperator(nameRegex)) {
                nameRegex = nameRegex.substring(1);
                BiomeListDeserialiser.populateBlacklistForName(validBiomes, nameRegex);
            } else {
                BiomeListDeserialiser.populateWhitelistForName(validBiomes, nameRegex);
            }
        });
        biomeList.removeIf(biome -> !validBiomes.contains(biome));
    };
    private final VoidApplier<BiomeList, JsonObject> andOperator = (biomes, jsonObject) -> this.applyAllAppliers((JsonObject)jsonObject, (BiomeList)biomes);
    private final VoidApplier<BiomeList, JsonArray> orOperator = (biomeList, json) -> {
        BiomeList biomesList = new BiomeList();
        JsonResult.forInput((JsonElement)json).mapEachIfArray(JsonObject.class, object -> {
            BiomeList subList = BiomeList.getAll();
            this.applyAllAppliers((JsonObject)object, subList);
            biomesList.addAll(subList);
            return object;
        }).orElse(null, arg_0 -> ((Logger)LogManager.getLogger()).error(arg_0), arg_0 -> ((Logger)LogManager.getLogger()).warn(arg_0));
        biomeList.removeIf(biome -> !biomesList.contains(biome));
    };
    private final VoidApplier<BiomeList, JsonObject> notOperator = (biomeList, jsonObject) -> {
        BiomeList notBiomeList = BiomeList.getAll();
        this.applyAllAppliers((JsonObject)jsonObject, notBiomeList);
        notBiomeList.forEach(biomeList::remove);
    };
    private final JsonPropertyAppliers<BiomeList> appliers = new JsonPropertyAppliers<BiomeList>(BiomeList.class);

    private static void removeBiomesWithMatchingType(BiomeList biomeList, String typeRegex) {
        biomeList.removeIf(biome -> BiomeListDeserialiser.getBiomeTypes(biome).stream().anyMatch(type -> BiomeListDeserialiser.typeMatches(typeRegex, type)));
    }

    private static void removeBiomesWithoutMatchingType(BiomeList biomeList, String typeRegex) {
        biomeList.removeIf(biome -> BiomeListDeserialiser.getBiomeTypes(biome).stream().noneMatch(type -> BiomeListDeserialiser.typeMatches(typeRegex, type)));
    }

    private static boolean typeMatches(String typeRegex, BiomeDictionary.Type type) {
        return type.toString().toLowerCase().matches(typeRegex);
    }

    private static Set<BiomeDictionary.Type> getBiomeTypes(Biome biome) {
        return BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(biome.getRegistryName())));
    }

    private static void removeBiomesWithMatchingCategory(BiomeList biomeList, String categoryRegex) {
        biomeList.removeIf(biome -> BiomeListDeserialiser.biomeCategoryMatches(categoryRegex, biome));
    }

    private static void removeBiomesWithoutMatchingCategory(BiomeList biomeList, String categoryRegex) {
        biomeList.removeIf(biome -> !BiomeListDeserialiser.biomeCategoryMatches(categoryRegex, biome));
    }

    private static boolean biomeCategoryMatches(String categoryRegex, Biome biome) {
        return biome.func_201856_r().toString().toLowerCase().matches(categoryRegex);
    }

    private static boolean usingNotOperator(String categoryString) {
        return categoryString.toCharArray()[0] == '!';
    }

    private static void removeBiomesWithMatchingName(BiomeList biomeList, String nameRegex) {
        biomeList.removeIf(biome -> BiomeListDeserialiser.biomeNameMatches(nameRegex, biome));
    }

    private static void removeBiomesWithoutMatchingName(BiomeList biomeList, String nameRegex) {
        biomeList.removeIf(biome -> !BiomeListDeserialiser.biomeNameMatches(nameRegex, biome));
    }

    private static boolean biomeNameMatches(String nameRegex, Biome biome) {
        return String.valueOf(biome.getRegistryName()).matches(nameRegex);
    }

    private static void populateListsForName(BiomeList whitelist, BiomeList blacklist, String nameRegex) {
        if (BiomeListDeserialiser.usingNotOperator(nameRegex)) {
            nameRegex = nameRegex.substring(1);
            BiomeListDeserialiser.populateBlacklistForName(whitelist, nameRegex);
        } else {
            BiomeListDeserialiser.populateWhitelistForName(blacklist, nameRegex);
        }
    }

    private static void populateWhitelistForName(BiomeList whitelist, String nameRegex) {
        ForgeRegistries.BIOMES.getValues().stream().filter(biome -> BiomeListDeserialiser.biomeNameMatches(nameRegex, biome)).forEach(whitelist::add);
    }

    private static void populateBlacklistForName(BiomeList blacklist, String nameRegex) {
        ForgeRegistries.BIOMES.getValues().stream().filter(biome -> !BiomeListDeserialiser.biomeNameMatches(nameRegex, biome)).forEach(blacklist::add);
    }

    public BiomeListDeserialiser() {
        this.registerAppliers();
    }

    private void registerAppliers() {
        ((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)((JsonPropertyAppliers)this.appliers.register("type", (Class)String.class, TYPE_APPLIER)).registerArrayApplier("types", (Class)String.class, (VoidApplier)TYPE_APPLIER)).register("category", (Class)String.class, (VoidApplier)CATEGORY_APPLIER)).register("name", (Class)String.class, (VoidApplier)NAME_APPLIER)).registerArrayApplier("names", (Class)String.class, (VoidApplier)NAME_APPLIER)).register("names_or", (Class)JsonArray.class, (VoidApplier)NAMES_OR_APPLIER)).registerArrayApplier("AND", (Class)JsonObject.class, (VoidApplier)this.andOperator)).register("OR", (Class)JsonArray.class, (VoidApplier)this.orOperator)).register("NOT", (Class)JsonObject.class, (VoidApplier)this.notOperator);
    }

    private void applyAllAppliers(JsonObject json, BiomeList biomes) {
        this.appliers.applyAll(new JsonMapWrapper(json), biomes);
    }

    @Override
    public Result<BiomeList, JsonElement> deserialise(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(Biome.class, biome -> new BiomeList((Collection<? extends Biome>)Collections.singletonList(biome))).elseMapIfType(JsonObject.class, selectorObject -> {
            BiomeList biomes = BiomeList.getAll();
            this.applyAllAppliers((JsonObject)selectorObject, biomes);
            return biomes;
        }).elseTypeError();
    }
}

