/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonPropertyApplierLists;
import com.ferreusveritas.dynamictrees.util.IgnoreThrowable;
import com.ferreusveritas.dynamictrees.util.JsonMapWrapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static Gson getGson() {
        return GSON;
    }

    @Nullable
    public static JsonElement load(@Nullable File file) {
        if (file != null && file.exists() && file.isFile() && file.canRead()) {
            String fileName = file.getAbsolutePath();
            try {
                JsonParser parser = new JsonParser();
                return parser.parse((Reader)new FileReader(file));
            }
            catch (Exception e) {
                LOGGER.fatal("Can't open " + fileName + ": " + e.getMessage());
            }
        }
        return null;
    }

    public static boolean isComment(JsonElement jsonElement) {
        return JsonDeserialisers.STRING.deserialise(jsonElement).map(string -> JsonHelper.isComment(string)).orElse(false);
    }

    public static boolean isComment(String key) {
        return key.startsWith("_");
    }

    public static <T> T getOrDefault(JsonObject jsonObject, String elementName, Class<T> type, T defaultValue) {
        JsonElement element = jsonObject.get(elementName);
        if (element == null) {
            return defaultValue;
        }
        return (T)JsonDeserialisers.get(type).deserialise(element).orElse(defaultValue);
    }

    public static <T> T getOrDefault(JsonObject jsonObject, String elementName, Class<T> type, T defaultValue, Consumer<String> errorConsumer, Consumer<String> warningConsumer) {
        JsonElement element = jsonObject.get(elementName);
        if (element == null) {
            return defaultValue;
        }
        return (T)JsonDeserialisers.get(type).deserialise(element).orElse(defaultValue, errorConsumer, warningConsumer);
    }

    public static <T> Optional<T> getAsOptional(JsonObject object, String key, JsonDeserialiser<T> deserialiser) throws DeserialisationException {
        JsonElement element = object.get(key);
        return element == null ? Optional.empty() : (Optional)deserialiser.deserialise(element).map(Optional::ofNullable).orElseThrow();
    }

    public static AbstractBlock.Properties getBlockProperties(JsonObject jsonObject, Material defaultMaterial, MaterialColor defaultMaterialColor, BiFunction<Material, MaterialColor, AbstractBlock.Properties> defaultPropertiesGetter, Consumer<String> errorConsumer, Consumer<String> warningConsumer) {
        Material material = JsonHelper.getOrDefault(jsonObject, "material", Material.class, defaultMaterial);
        AbstractBlock.Properties properties = defaultPropertiesGetter.apply(material, JsonHelper.getOrDefault(jsonObject, "material_color", MaterialColor.class, defaultMaterialColor));
        JsonPropertyApplierLists.PROPERTIES.applyAll(new JsonMapWrapper(jsonObject), properties).forEachErrorWarning(errorConsumer, warningConsumer);
        return properties;
    }

    public static <T extends Throwable> void throwIfNotJsonObject(JsonElement json, Supplier<T> throwableSupplier) throws T {
        if (!json.isJsonObject()) {
            throw (Throwable)throwableSupplier.get();
        }
    }

    public static void throwIfShouldNotLoad(JsonObject json) throws IgnoreThrowable {
        boolean continueLoading;
        String key = "only_if_loaded";
        if (json.has("only_if_loaded") && !(continueLoading = JsonDeserialisers.STRING.deserialise(json.get("only_if_loaded")).map(modId -> ModList.get().isLoaded(modId)).orElse(true).booleanValue())) {
            throw IgnoreThrowable.INSTANCE;
        }
    }
}

