/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.api.treepacks.Applier;
import com.ferreusveritas.dynamictrees.api.treepacks.ArrayIteratorPropertyApplier;
import com.ferreusveritas.dynamictrees.api.treepacks.ArrayPropertyApplier;
import com.ferreusveritas.dynamictrees.api.treepacks.IfTrueApplier;
import com.ferreusveritas.dynamictrees.api.treepacks.JsonPropertyApplier;
import com.ferreusveritas.dynamictrees.api.treepacks.PropertyApplier;
import com.ferreusveritas.dynamictrees.api.treepacks.PropertyApplierResult;
import com.ferreusveritas.dynamictrees.api.treepacks.VoidApplier;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.PropertyAppliers;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class JsonPropertyAppliers<O>
implements PropertyAppliers<O, JsonElement> {
    private final Class<O> objectType;
    private final List<PropertyApplier<? extends O, ?, JsonElement>> appliers = Lists.newLinkedList();

    public JsonPropertyAppliers(Class<O> objectType) {
        this.objectType = objectType;
    }

    @Override
    public PropertyAppliers.ResultList applyAll(Map<String, JsonElement> json, O object) {
        PropertyAppliers.ResultList results = new PropertyAppliers.ResultList();
        for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
            results.add(this.apply(object, entry.getKey(), entry.getValue()));
        }
        return results;
    }

    @Override
    public PropertyApplierResult apply(O object, String key, JsonElement jsonElement) {
        if (JsonHelper.isComment(jsonElement)) {
            return PropertyApplierResult.success();
        }
        ArrayList<String> warnings = new ArrayList<String>();
        for (PropertyApplier<O, ?, JsonElement> applier : this.appliers) {
            PropertyApplierResult result;
            if (!applier.getObjectClass().isInstance(object) || (result = applier.applyIfShould(key, object, jsonElement)) == null) continue;
            if (!result.wasSuccessful()) {
                return result.addErrorPrefix("[" + key + "] ").addWarningsPrefix("[" + key + "] ");
            }
            warnings.addAll(result.getWarnings());
            break;
        }
        return PropertyApplierResult.success(warnings).addWarningsPrefix("[" + key + "] ");
    }

    public <E extends O> JsonPropertyAppliers<O> register(PropertyApplier<E, ?, JsonElement> applier) {
        this.appliers.add(applier);
        return this;
    }

    public <V> JsonPropertyAppliers<O> register(String key, Class<V> valueClass, Applier<O, V> applier) {
        return this.register(key, (Class)this.objectType, (Class)valueClass, applier);
    }

    public <V> JsonPropertyAppliers<O> register(String key, Class<V> valueClass, VoidApplier<O, V> applier) {
        return this.register(key, (Class)this.objectType, (Class)valueClass, applier);
    }

    public <V> JsonPropertyAppliers<O> registerArrayApplier(String key, Class<V> valueClass, Applier<O, V> applier) {
        return this.registerArrayApplier(key, (Class)this.objectType, (Class)valueClass, applier);
    }

    public <V> JsonPropertyAppliers<O> registerArrayApplier(String key, Class<V> valueClass, VoidApplier<O, V> applier) {
        return this.registerArrayApplier(key, (Class)this.objectType, (Class)valueClass, applier);
    }

    @Override
    public <V> PropertyAppliers<O, JsonElement> registerListApplier(String key, Class<V> valueClass, Applier<O, List<V>> applier) {
        return this.registerListApplier(key, this.objectType, valueClass, applier);
    }

    @Override
    public <V> PropertyAppliers<O, JsonElement> registerListApplier(String key, Class<V> valueClass, VoidApplier<O, List<V>> applier) {
        return this.registerListApplier(key, this.objectType, valueClass, applier);
    }

    public JsonPropertyAppliers<O> registerIfTrueApplier(String key, IfTrueApplier<O> applier) {
        return this.registerIfTrueApplier(key, this.objectType, applier);
    }

    public <E extends O, V> JsonPropertyAppliers<O> register(String key, Class<E> subClass, Class<V> valueClass, Applier<E, V> applier) {
        return this.register(new JsonPropertyApplier<E, V>(key, subClass, valueClass, applier));
    }

    public <E extends O, V> JsonPropertyAppliers<O> register(String key, Class<E> subClass, Class<V> valueClass, VoidApplier<E, V> applier) {
        return this.register(new JsonPropertyApplier<E, V>(key, subClass, valueClass, applier));
    }

    public <E extends O> JsonPropertyAppliers<O> registerIfTrueApplier(String key, Class<E> subClass, IfTrueApplier<E> applier) {
        return this.register(key, (Class)subClass, (Class)Boolean.class, (O object, V value) -> {
            if (value.booleanValue()) {
                applier.apply(object);
            }
        });
    }

    public <E extends O, V> JsonPropertyAppliers<O> registerArrayApplier(String key, Class<E> subClass, Class<V> valueClass, Applier<E, V> applier) {
        return this.register(ArrayIteratorPropertyApplier.json(key, subClass, valueClass, new JsonPropertyApplier<E, V>("", subClass, valueClass, applier)));
    }

    public <E extends O, V> JsonPropertyAppliers<O> registerArrayApplier(String key, Class<E> subClass, Class<V> valueClass, VoidApplier<E, V> applier) {
        return this.register(ArrayIteratorPropertyApplier.json(key, subClass, valueClass, new JsonPropertyApplier<E, V>("", subClass, valueClass, applier)));
    }

    @Override
    public <E extends O, V> PropertyAppliers<O, JsonElement> registerListApplier(String key, Class<E> subClass, Class<V> valueClass, Applier<E, List<V>> applier) {
        return this.register(ArrayPropertyApplier.json(key, subClass, valueClass, applier));
    }

    @Override
    public <E extends O, V> PropertyAppliers<O, JsonElement> registerListApplier(String key, Class<E> subClass, Class<V> valueClass, VoidApplier<E, List<V>> applier) {
        return this.register(ArrayPropertyApplier.json(key, subClass, valueClass, applier));
    }

    @Override
    public Class<O> getObjectType() {
        return this.objectType;
    }
}

