/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public final class MaterialColorDeserialiser
implements JsonDeserialiser<MaterialColor> {
    private static final Map<ResourceLocation, MaterialColor> MATERIAL_COLORS = (Map)Util.func_200696_a(new HashMap(), materialColors -> {
        materialColors.put(new ResourceLocation("none"), MaterialColor.field_151660_b);
        materialColors.put(new ResourceLocation("grass"), MaterialColor.field_151661_c);
        materialColors.put(new ResourceLocation("sand"), MaterialColor.field_151658_d);
        materialColors.put(new ResourceLocation("wool"), MaterialColor.field_151659_e);
        materialColors.put(new ResourceLocation("fire"), MaterialColor.field_151656_f);
        materialColors.put(new ResourceLocation("ice"), MaterialColor.field_151657_g);
        materialColors.put(new ResourceLocation("metal"), MaterialColor.field_151668_h);
        materialColors.put(new ResourceLocation("plant"), MaterialColor.field_151669_i);
        materialColors.put(new ResourceLocation("snow"), MaterialColor.field_151666_j);
        materialColors.put(new ResourceLocation("clay"), MaterialColor.field_151667_k);
        materialColors.put(new ResourceLocation("dirt"), MaterialColor.field_151664_l);
        materialColors.put(new ResourceLocation("stone"), MaterialColor.field_151665_m);
        materialColors.put(new ResourceLocation("water"), MaterialColor.field_151662_n);
        materialColors.put(new ResourceLocation("wood"), MaterialColor.field_151663_o);
        materialColors.put(new ResourceLocation("quartz"), MaterialColor.field_151677_p);
        materialColors.put(new ResourceLocation("color_orange"), MaterialColor.field_151676_q);
        materialColors.put(new ResourceLocation("color_magenta"), MaterialColor.field_151675_r);
        materialColors.put(new ResourceLocation("color_light_blue"), MaterialColor.field_151674_s);
        materialColors.put(new ResourceLocation("color_yellow"), MaterialColor.field_151673_t);
        materialColors.put(new ResourceLocation("color_light_green"), MaterialColor.field_151672_u);
        materialColors.put(new ResourceLocation("color_pink"), MaterialColor.field_151671_v);
        materialColors.put(new ResourceLocation("color_gray"), MaterialColor.field_151670_w);
        materialColors.put(new ResourceLocation("color_light_gray"), MaterialColor.field_197656_x);
        materialColors.put(new ResourceLocation("color_cyan"), MaterialColor.field_151679_y);
        materialColors.put(new ResourceLocation("color_purple"), MaterialColor.field_151678_z);
        materialColors.put(new ResourceLocation("color_blue"), MaterialColor.field_151649_A);
        materialColors.put(new ResourceLocation("color_brown"), MaterialColor.field_151650_B);
        materialColors.put(new ResourceLocation("color_green"), MaterialColor.field_151651_C);
        materialColors.put(new ResourceLocation("color_red"), MaterialColor.field_151645_D);
        materialColors.put(new ResourceLocation("color_black"), MaterialColor.field_151646_E);
        materialColors.put(new ResourceLocation("gold"), MaterialColor.field_151647_F);
        materialColors.put(new ResourceLocation("diamond"), MaterialColor.field_151648_G);
        materialColors.put(new ResourceLocation("lapis"), MaterialColor.field_151652_H);
        materialColors.put(new ResourceLocation("emerald"), MaterialColor.field_151653_I);
        materialColors.put(new ResourceLocation("podzol"), MaterialColor.field_151654_J);
        materialColors.put(new ResourceLocation("nether"), MaterialColor.field_151655_K);
        materialColors.put(new ResourceLocation("terracotta_white"), MaterialColor.field_193561_M);
        materialColors.put(new ResourceLocation("terracotta_orange"), MaterialColor.field_193562_N);
        materialColors.put(new ResourceLocation("terracotta_magenta"), MaterialColor.field_193563_O);
        materialColors.put(new ResourceLocation("terracotta_light_blue"), MaterialColor.field_193564_P);
        materialColors.put(new ResourceLocation("terracotta_yellow"), MaterialColor.field_193565_Q);
        materialColors.put(new ResourceLocation("terracotta_light_green"), MaterialColor.field_193566_R);
        materialColors.put(new ResourceLocation("terracotta_pink"), MaterialColor.field_193567_S);
        materialColors.put(new ResourceLocation("terracotta_gray"), MaterialColor.field_193568_T);
        materialColors.put(new ResourceLocation("terracotta_light_gray"), MaterialColor.field_197655_T);
        materialColors.put(new ResourceLocation("terracotta_cyan"), MaterialColor.field_193570_V);
        materialColors.put(new ResourceLocation("terracotta_purple"), MaterialColor.field_193571_W);
        materialColors.put(new ResourceLocation("terracotta_blue"), MaterialColor.field_193572_X);
        materialColors.put(new ResourceLocation("terracotta_brown"), MaterialColor.field_193573_Y);
        materialColors.put(new ResourceLocation("terracotta_green"), MaterialColor.field_193574_Z);
        materialColors.put(new ResourceLocation("terracotta_red"), MaterialColor.field_193559_aa);
        materialColors.put(new ResourceLocation("terracotta_black"), MaterialColor.field_193560_ab);
        materialColors.put(new ResourceLocation("crimson_nylium"), MaterialColor.field_241539_ab_);
        materialColors.put(new ResourceLocation("crimson_stem"), MaterialColor.field_241540_ac_);
        materialColors.put(new ResourceLocation("crimson_hyphae"), MaterialColor.field_241541_ad_);
        materialColors.put(new ResourceLocation("warped_nylium"), MaterialColor.field_241542_ae_);
        materialColors.put(new ResourceLocation("warped_stem"), MaterialColor.field_241543_af_);
        materialColors.put(new ResourceLocation("warped_hyphae"), MaterialColor.field_241544_ag_);
        materialColors.put(new ResourceLocation("warped_wart_block"), MaterialColor.field_241545_ah_);
    });

    public static void registerMaterialColor(ResourceLocation name, MaterialColor materialColor) {
        MATERIAL_COLORS.putIfAbsent(name, materialColor);
    }

    @Override
    public Result<MaterialColor, JsonElement> deserialise(JsonElement input) {
        return JsonDeserialisers.RESOURCE_LOCATION.deserialise(input).map(MATERIAL_COLORS::get, "Could not get material color from \"{}\".");
    }
}

