/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public final class ResourceLocationDeserialiser
implements JsonDeserialiser<ResourceLocation> {
    private final String defaultNamespace;

    public ResourceLocationDeserialiser(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    public Result<ResourceLocation, JsonElement> deserialise(JsonElement jsonElement) {
        return JsonDeserialisers.STRING.deserialise(jsonElement).map(string -> string.toLowerCase(Locale.ROOT)).mapIfValid(ResourceLocationDeserialiser::isValidResourceLocation, "Invalid resource location '{value}'. Namespace Constraints: [a-z0-9_.-] Path Constraints: [a-z0-9/._-]", this::decode);
    }

    public static boolean isValidResourceLocation(String p_217855_0_) {
        String[] namespaceAndPath = ResourceLocation.func_195823_b((String)p_217855_0_, (char)':');
        return ResourceLocation.func_217858_d((String)(StringUtils.isEmpty((CharSequence)namespaceAndPath[0]) ? "minecraft" : namespaceAndPath[0])) && ResourceLocation.func_217856_c((String)namespaceAndPath[1]);
    }

    private ResourceLocation decode(String resLocStr) {
        String[] namespaceAndPath = new String[]{this.defaultNamespace, resLocStr};
        int colonIndex = resLocStr.indexOf(58);
        if (colonIndex >= 0) {
            namespaceAndPath[1] = resLocStr.substring(colonIndex + 1);
            if (colonIndex >= 1) {
                namespaceAndPath[0] = resLocStr.substring(0, colonIndex);
            }
        }
        return new ResourceLocation(namespaceAndPath[0], namespaceAndPath[1]);
    }

    public static ResourceLocationDeserialiser create() {
        return new ResourceLocationDeserialiser("minecraft");
    }

    public static ResourceLocationDeserialiser create(String defaultNamespace) {
        return new ResourceLocationDeserialiser(defaultNamespace);
    }
}

