/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation.result;

import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.MappedResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class MappedJsonResult<T>
extends JsonResult<T>
implements MappedResult<T, JsonElement> {
    public MappedJsonResult(JsonElement input, @Nullable T value, @Nullable String error) {
        super(input, value, error);
    }

    public MappedJsonResult(JsonElement input, @Nullable T value, @Nullable String error, List<String> warnings) {
        super(input, value, error, warnings);
    }

    @Override
    public <V> MappedResult<T, JsonElement> elseMapIfType(Class<V> type, Result.Mapper<V, T> mapper) {
        return this.value != null ? MappedJsonResult.map(this.value, this) : super.mapIfType(type, mapper);
    }

    @Override
    public <V> MappedResult<T, JsonElement> elseMapIfContains(String key, Class<V> type, Result.Mapper<V, T> mapper) {
        return this.value != null ? MappedJsonResult.map(this.value, this) : super.mapIfContains(key, type, mapper);
    }

    @Override
    public <V> MappedResult<T, JsonElement> elseMapIfContains(String key, Class<V> type, Result.Mapper<V, T> mapper, T defaultValue) {
        return this.value != null ? MappedJsonResult.map(this.value, this) : super.mapIfContains(key, type, mapper, defaultValue);
    }

    @Override
    public MappedResult<T, JsonElement> elseError(Predicate<T> validator, String invalidError) {
        return validator.test(this.value) ? this : MappedJsonResult.errorneousMap(invalidError.replace("{}", String.valueOf(this.value)), this);
    }

    static <T> MappedJsonResult<T> mapErrorneous(JsonResult<?> result) {
        return new MappedJsonResult<Object>((JsonElement)result.input, null, result.error, (List<String>)result.warnings);
    }

    static <V> MappedJsonResult<V> map(V value, JsonResult<?> unmapped) {
        return new MappedJsonResult<V>((JsonElement)unmapped.input, value, null, (List<String>)unmapped.warnings);
    }

    static <T> MappedJsonResult<T> errorneousMap(String error, JsonResult<?> unmapped) {
        return new MappedJsonResult<Object>((JsonElement)unmapped.input, null, error, (List<String>)unmapped.warnings);
    }
}

