/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities.animation;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.entities.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationConstants;
import com.ferreusveritas.dynamictrees.entities.animation.AnimationHandler;
import com.ferreusveritas.dynamictrees.entities.animation.DataAnimationHandler;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FalloverAnimationHandler
implements AnimationHandler {
    @Override
    public String getName() {
        return "fallover";
    }

    HandlerData getData(FallingTreeEntity entity) {
        return entity.dataAnimationHandler != null ? (HandlerData)entity.dataAnimationHandler : new HandlerData();
    }

    @Override
    public void initMotion(FallingTreeEntity entity) {
        entity.dataAnimationHandler = new HandlerData();
        FallingTreeEntity.standardDropLeavesPayLoad(entity);
        BlockPos belowBlock = entity.getDestroyData().cutPos.func_177977_b();
        if (entity.field_70170_p.func_180495_p(belowBlock).func_224755_d((IBlockReader)entity.field_70170_p, belowBlock, Direction.UP)) {
            entity.func_230245_c_(true);
            return;
        }
    }

    @Override
    public void handleMotion(FallingTreeEntity entity) {
        float fallSpeed = this.getData((FallingTreeEntity)entity).fallSpeed;
        if (entity.func_233570_aj_()) {
            float height = (float)entity.getMassCenter().field_72448_b * 2.0f;
            fallSpeed = (float)((double)fallSpeed + 0.2 / (double)height);
            this.addRotation(entity, fallSpeed);
        }
        entity.func_213293_j(entity.func_213322_ci().field_72450_a, entity.func_213322_ci().field_72448_b - (double)0.03f, entity.func_213322_ci().field_72449_c);
        entity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + entity.func_213322_ci().field_72448_b, entity.func_226281_cx_());
        World world = entity.field_70170_p;
        int radius = 8;
        BlockState state = entity.getDestroyData().getBranchBlockState(0);
        if (TreeHelper.isBranch(state)) {
            radius = ((BranchBlock)state.func_177230_c()).getRadius(state);
        }
        AxisAlignedBB fallBox = new AxisAlignedBB(entity.func_226277_ct_() - (double)radius, entity.func_226278_cu_(), entity.func_226281_cx_() - (double)radius, entity.func_226277_ct_() + (double)radius, entity.func_226278_cu_() + 1.0, entity.func_226281_cx_() + (double)radius);
        BlockPos pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        BlockState collState = world.func_180495_p(pos);
        VoxelShape shape = collState.func_196951_e((IBlockReader)world, pos);
        AxisAlignedBB collBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (!shape.func_197766_b()) {
            collBox = collState.func_196951_e((IBlockReader)world, pos).func_197752_a();
        }
        if (fallBox.func_72326_a(collBox = collBox.func_186670_a(pos))) {
            entity.func_213293_j(entity.func_213322_ci().field_72450_a, 0.0, entity.func_213322_ci().field_72449_c);
            entity.func_70107_b(entity.func_226277_ct_(), collBox.field_72337_e, entity.func_226281_cx_());
            entity.field_70167_r = entity.func_226278_cu_();
            entity.func_230245_c_(true);
        }
        if (fallSpeed > 0.0f && this.testCollision(entity)) {
            this.addRotation(entity, -fallSpeed);
            ++this.getData((FallingTreeEntity)entity).bounces;
            entity.landed = Math.abs(fallSpeed *= -0.25f) < 0.02f;
        }
        world = entity.field_70170_p;
        if (((Boolean)DTConfigs.ENABLE_FALLING_TREE_DAMAGE.get()).booleanValue() && !world.field_72995_K) {
            List<LivingEntity> elist = this.testEntityCollision(entity);
            for (LivingEntity living : elist) {
                if (this.getData((FallingTreeEntity)entity).entitiesHit.contains(living)) continue;
                this.getData((FallingTreeEntity)entity).entitiesHit.add(living);
                float damage = entity.getDestroyData().woodVolume.getVolume() * Math.abs(fallSpeed) * 3.0f;
                if (this.getData((FallingTreeEntity)entity).bounces != 0 || !(damage > 2.0f)) continue;
                living.func_213293_j(living.func_213322_ci().field_72450_a + (double)(world.field_73012_v.nextFloat() * (float)entity.getDestroyData().toolDir.func_176734_d().func_82601_c() * damage * 0.2f), living.func_213322_ci().field_72448_b + (double)(world.field_73012_v.nextFloat() * fallSpeed * 0.25f), living.func_213322_ci().field_72449_c + (double)(world.field_73012_v.nextFloat() * (float)entity.getDestroyData().toolDir.func_176734_d().func_82599_e() * damage * 0.2f));
                living.func_213293_j(living.func_213322_ci().field_72450_a + ((double)world.field_73012_v.nextFloat() - 0.5), living.func_213322_ci().field_72448_b, living.func_213322_ci().field_72449_c + ((double)world.field_73012_v.nextFloat() - 0.5));
                damage = (float)((double)damage * (Double)DTConfigs.FALLING_TREE_DAMAGE_MULTIPLIER.get());
                living.func_70097_a((DamageSource)AnimationConstants.TREE_DAMAGE, damage);
            }
        }
        this.getData((FallingTreeEntity)entity).fallSpeed = fallSpeed;
    }

    private boolean testCollision(FallingTreeEntity entity) {
        Direction toolDir = entity.getDestroyData().toolDir;
        float actingAngle = toolDir.func_176740_k() == Direction.Axis.X ? entity.field_70177_z : entity.field_70125_A;
        int offsetX = toolDir.func_82601_c();
        int offsetZ = toolDir.func_82599_e();
        float h = MathHelper.func_76126_a((float)((float)Math.toRadians(actingAngle))) * (float)(offsetX | offsetZ);
        float v = MathHelper.func_76134_b((float)((float)Math.toRadians(actingAngle)));
        float xbase = (float)(entity.func_226277_ct_() + (double)((float)offsetX * (-0.5f + v * 0.5f + h * 0.5f)));
        float ybase = (float)(entity.func_226278_cu_() - (double)(h * 0.5f) + (double)(v * 0.5f));
        float zbase = (float)(entity.func_226281_cx_() + (double)((float)offsetZ * (-0.5f + v * 0.5f + h * 0.5f)));
        int trunkHeight = entity.getDestroyData().trunkHeight;
        float maxRadius = (float)entity.getDestroyData().getBranchRadius(0) / 16.0f;
        trunkHeight = Math.min(trunkHeight, 24);
        for (int segment = 0; segment < trunkHeight; ++segment) {
            float segX = xbase + h * (float)segment * (float)offsetX;
            float segY = ybase + v * (float)segment;
            float segZ = zbase + h * (float)segment * (float)offsetZ;
            float tex = 0.0625f;
            float half = MathHelper.func_76131_a((float)(tex * (float)(segment + 1) * 2.0f), (float)tex, (float)maxRadius);
            AxisAlignedBB testBB = new AxisAlignedBB((double)(segX - half), (double)(segY - half), (double)(segZ - half), (double)(segX + half), (double)(segY + half), (double)(segZ + half));
            if (entity.field_70170_p.func_226665_a__((Entity)entity, testBB)) continue;
            return true;
        }
        return false;
    }

    private void addRotation(FallingTreeEntity entity, float delta) {
        Direction toolDir = entity.getDestroyData().toolDir;
        switch (toolDir) {
            case NORTH: {
                entity.field_70125_A += delta;
                break;
            }
            case SOUTH: {
                entity.field_70125_A -= delta;
                break;
            }
            case WEST: {
                entity.field_70177_z += delta;
                break;
            }
            case EAST: {
                entity.field_70177_z -= delta;
                break;
            }
        }
        entity.field_70125_A = MathHelper.func_76142_g((float)entity.field_70125_A);
        entity.field_70177_z = MathHelper.func_76142_g((float)entity.field_70177_z);
    }

    public List<LivingEntity> testEntityCollision(FallingTreeEntity entity) {
        World world = entity.field_70170_p;
        Direction toolDir = entity.getDestroyData().toolDir;
        float actingAngle = toolDir.func_176740_k() == Direction.Axis.X ? entity.field_70177_z : entity.field_70125_A;
        int offsetX = toolDir.func_82601_c();
        int offsetZ = toolDir.func_82599_e();
        float h = MathHelper.func_76126_a((float)((float)Math.toRadians(actingAngle))) * (float)(offsetX | offsetZ);
        float v = MathHelper.func_76134_b((float)((float)Math.toRadians(actingAngle)));
        float xbase = (float)(entity.func_226277_ct_() + (double)((float)offsetX * (-0.5f + v * 0.5f + h * 0.5f)));
        float ybase = (float)(entity.func_226278_cu_() - (double)(h * 0.5f) + (double)(v * 0.5f));
        float zbase = (float)(entity.func_226281_cx_() + (double)((float)offsetZ * (-0.5f + v * 0.5f + h * 0.5f)));
        int trunkHeight = entity.getDestroyData().trunkHeight;
        float segX = xbase + h * (float)(trunkHeight - 1) * (float)offsetX;
        float segY = ybase + v * (float)(trunkHeight - 1);
        float segZ = zbase + h * (float)(trunkHeight - 1) * (float)offsetZ;
        float maxRadius = (float)entity.getDestroyData().getBranchRadius(0) / 16.0f;
        Vector3d vec3d1 = new Vector3d((double)xbase, (double)ybase, (double)zbase);
        Vector3d vec3d2 = new Vector3d((double)segX, (double)segY, (double)segZ);
        return world.func_175674_a((Entity)entity, new AxisAlignedBB(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c), entity1 -> {
            if (entity1 instanceof LivingEntity && entity1.func_70067_L()) {
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)maxRadius);
                return axisalignedbb.func_72318_a(vec3d1) || FalloverAnimationHandler.intersects(axisalignedbb, vec3d1, vec3d2);
            }
            return false;
        }).stream().map(a -> (LivingEntity)a).collect(Collectors.toList());
    }

    public static boolean intersects(AxisAlignedBB axisAlignedBB, Vector3d vec3d, Vector3d otherVec3d) {
        return axisAlignedBB.func_186668_a(Math.min(vec3d.field_72450_a, otherVec3d.field_72450_a), Math.min(vec3d.field_72448_b, otherVec3d.field_72448_b), Math.min(vec3d.field_72449_c, otherVec3d.field_72449_c), Math.max(vec3d.field_72450_a, otherVec3d.field_72450_a), Math.max(vec3d.field_72448_b, otherVec3d.field_72448_b), Math.max(vec3d.field_72449_c, otherVec3d.field_72449_c));
    }

    @Override
    public void dropPayload(FallingTreeEntity entity) {
        World world = entity.field_70170_p;
        BlockPos cutPos = entity.getDestroyData().cutPos;
        entity.getPayload().forEach(i -> Block.func_180635_a((World)world, (BlockPos)cutPos, (ItemStack)i));
    }

    @Override
    public boolean shouldDie(FallingTreeEntity entity) {
        boolean dead;
        boolean bl = dead = Math.abs(entity.field_70125_A) >= 160.0f || Math.abs(entity.field_70177_z) >= 160.0f || entity.landed || entity.field_70173_aa > 120 + entity.getDestroyData().trunkHeight;
        if (dead) {
            entity.cleanupRootyDirt();
        }
        return dead;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTransform(FallingTreeEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack) {
        float yaw = MathHelper.func_76142_g((float)com.ferreusveritas.dynamictrees.util.MathHelper.angleDegreesInterpolate(entity.field_70126_B, entity.field_70177_z, partialTicks));
        float pit = MathHelper.func_76142_g((float)com.ferreusveritas.dynamictrees.util.MathHelper.angleDegreesInterpolate(entity.field_70127_C, entity.field_70125_A, partialTicks));
        int radius = entity.getDestroyData().getBranchRadius(0);
        Direction toolDir = entity.getDestroyData().toolDir;
        Vector3d toolVec = new Vector3d((double)toolDir.func_82601_c(), (double)toolDir.func_96559_d(), (double)toolDir.func_82599_e()).func_186678_a((double)((float)radius / 16.0f));
        matrixStack.func_227861_a_(-toolVec.field_72450_a, -toolVec.field_72448_b, -toolVec.field_72449_c);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 0.0f, 1.0f), -yaw, true));
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), pit, true));
        matrixStack.func_227861_a_(toolVec.field_72450_a, toolVec.field_72448_b, toolVec.field_72449_c);
        matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(FallingTreeEntity entity) {
        return true;
    }

    class HandlerData
    extends DataAnimationHandler {
        float fallSpeed = 0.0f;
        int bounces = 0;
        HashSet<LivingEntity> entitiesHit = new HashSet();

        HandlerData() {
        }
    }
}

