/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurableRegistry;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurableRegistryEntry;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public abstract class GrowthLogicKit
extends ConfigurableRegistryEntry<GrowthLogicKit, GrowthLogicKitConfiguration> {
    public static final ConfigurationProperty<Integer> HEIGHT_VARIATION = ConfigurationProperty.integer("height_variation");
    public static final GrowthLogicKit DEFAULT = new GrowthLogicKit(DTTrees.NULL){

        @Override
        public GrowthLogicKitConfiguration getDefaultConfiguration() {
            return (GrowthLogicKitConfiguration)this.defaultConfiguration;
        }
    };
    public static final ConfigurableRegistry<GrowthLogicKit, GrowthLogicKitConfiguration> REGISTRY = new ConfigurableRegistry<GrowthLogicKit, GrowthLogicKitConfiguration>(GrowthLogicKit.class, DEFAULT, GrowthLogicKitConfiguration.TEMPLATES);

    public GrowthLogicKit(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return new GrowthLogicKitConfiguration(this);
    }

    @Override
    protected void registerProperties() {
    }

    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        if (context.signal().numSteps + 1 <= configuration.getLowestBranchHeight(new PositionalSpeciesContext(context.world(), context.signal().rootPos, context.species())) && !context.signal().getSpecies().getLeavesProperties().canGrowOnGround()) {
            return Direction.UP;
        }
        int[] probMap = configuration.populateDirectionProbabilityMap(new DirectionManipulationContext(context.world(), context.pos(), context.species(), context.branch(), context.signal(), context.branch().getRadius(context.world().func_180495_p(context.pos())), new int[6]));
        int choice = MathHelper.selectRandomFromDistribution(context.signal().rand, probMap);
        return Direction.values()[choice != -1 ? choice : 1];
    }

    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        Direction originDir = context.signal().dir.func_176734_d();
        probMap[Direction.UP.ordinal()] = context.signal().dir != Direction.DOWN ? context.species().getUpProbability() : 0;
        int n = context.signal().dir.ordinal();
        probMap[n] = probMap[n] + context.species().getProbabilityForCurrentDir();
        for (Direction dir : Direction.values()) {
            if (dir.equals((Object)originDir)) continue;
            BlockPos deltaPos = context.pos().func_177972_a(dir);
            BlockState deltaBlockState = context.world().func_180495_p(deltaPos);
            int n2 = dir.func_176745_a();
            probMap[n2] = probMap[n2] + TreeHelper.getTreePart(deltaBlockState).probabilityForBlock(deltaBlockState, (IBlockReader)context.world(), deltaPos, context.branch());
        }
        return probMap;
    }

    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return context.species().getSignalEnergy();
    }

    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return context.species().getLowestBranchHeight();
    }
}

