/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.growthlogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NetherFungusLogic
extends GrowthLogicKit {
    public static final ConfigurationProperty<Integer> MIN_CAP_HEIGHT = ConfigurationProperty.integer("min_cap_height");

    public NetherFungusLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(MIN_CAP_HEIGHT, 3)).with(HEIGHT_VARIATION, 8);
    }

    @Override
    protected void registerProperties() {
        this.register(MIN_CAP_HEIGHT, HEIGHT_VARIATION);
    }

    @Override
    public Direction selectNewDirection(GrowthLogicKitConfiguration configuration, DirectionSelectionContext context) {
        Direction newDir = super.selectNewDirection(configuration, context);
        if (context.signal().isInTrunk() && newDir != Direction.UP) {
            context.signal().energy = Math.min(context.signal().energy, context.species().isMegaSpecies() ? 3.0f : 2.0f);
        }
        return newDir;
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = super.populateDirectionProbabilityMap(configuration, context);
        if (context.signal().isInTrunk()) {
            if (TreeHelper.isBranch(context.world().func_180495_p(context.pos().func_177984_a())) && !TreeHelper.isBranch(context.world().func_180495_p(context.pos().func_177981_b(3)))) {
                context.probMap(new int[]{0, 0, 0, 0, 0, 0});
            } else if (!context.species().isMegaSpecies()) {
                for (Direction direction : CoordUtils.HORIZONTALS) {
                    if (!TreeHelper.isBranch(context.world().func_180495_p(context.pos().func_177971_a(direction.func_176734_d().func_176730_m())))) continue;
                    probMap[direction.func_176745_a()] = 0;
                }
            }
            probMap[Direction.UP.func_176745_a()] = 4;
        } else {
            probMap[Direction.UP.func_176745_a()] = 0;
        }
        return probMap;
    }

    private float getHashedVariation(GrowthLogicKitConfiguration configuration, World world, BlockPos pos) {
        long day = world.func_82737_E() / 24000L;
        int month = (int)day / 30;
        return CoordUtils.coordHashCode(pos.func_177981_b(month), 2) % (Integer)configuration.get(HEIGHT_VARIATION);
    }

    @Override
    public float getEnergy(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return Math.min((float)(configuration.getLowestBranchHeight(new PositionalSpeciesContext(context.world(), context.pos(), context.species())) + configuration.get(MIN_CAP_HEIGHT)) + this.getHashedVariation(configuration, context.world(), context.pos()) / 1.5f, super.getEnergy(configuration, context));
    }

    @Override
    public int getLowestBranchHeight(GrowthLogicKitConfiguration configuration, PositionalSpeciesContext context) {
        return (int)((float)super.getLowestBranchHeight(configuration, context) * context.species().biomeSuitability(context.world(), context.pos()) + this.getHashedVariation(configuration, context.world(), context.pos()));
    }
}

