/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.condition;

import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.loot.DTLootParameters;
import com.ferreusveritas.dynamictrees.loot.condition.DTLootConditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;

public final class SeasonalSeedDropChance
implements ILootCondition {
    private static final SeasonalSeedDropChance INSTANCE = new SeasonalSeedDropChance();

    private SeasonalSeedDropChance() {
    }

    public LootConditionType func_230419_b_() {
        return DTLootConditions.SEASONAL_SEED_DROP_CHANCE;
    }

    public boolean test(LootContext context) {
        Float seasonalSeedDropFactor = (Float)context.func_216031_c(DTLootParameters.SEASONAL_SEED_DROP_FACTOR);
        assert (seasonalSeedDropFactor != null);
        float adjustedSeasonalSeedDropFactor = Math.min(seasonalSeedDropFactor.floatValue() + 0.15f, 1.0f);
        return (Double)DTConfigs.SEED_DROP_RATE.get() * (double)adjustedSeasonalSeedDropFactor > (double)context.func_216032_b().nextFloat();
    }

    public static ILootCondition.IBuilder seasonalSeedDropChance() {
        return () -> INSTANCE;
    }

    public static class Serializer
    implements ILootSerializer<SeasonalSeedDropChance> {
        public void serialize(JsonObject json, SeasonalSeedDropChance value, JsonSerializationContext context) {
        }

        public SeasonalSeedDropChance deserialize(JsonObject json, JsonDeserializationContext context) {
            return INSTANCE;
        }
    }
}

