/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.condition;

import com.ferreusveritas.dynamictrees.loot.DTLootParameters;
import com.ferreusveritas.dynamictrees.loot.condition.DTLootConditions;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;

public final class SpeciesMatches
implements ILootCondition {
    private final String regex;

    public SpeciesMatches(String regex) {
        this.regex = regex;
    }

    public LootConditionType func_230419_b_() {
        return DTLootConditions.SPECIES_MATCHES;
    }

    public boolean test(LootContext context) {
        Species species = (Species)context.func_216031_c(DTLootParameters.SPECIES);
        assert (species != null);
        return String.valueOf(species.getRegistryName()).matches(this.regex);
    }

    public static ILootCondition.IBuilder speciesMatches(String regex) {
        return () -> new SpeciesMatches(regex);
    }

    public static class Serializer
    implements ILootSerializer<SpeciesMatches> {
        public void serialize(JsonObject json, SpeciesMatches value, JsonSerializationContext context) {
            json.addProperty("name", String.valueOf(value.regex));
        }

        public SpeciesMatches deserialize(JsonObject json, JsonDeserializationContext context) {
            return new SpeciesMatches(JSONUtils.func_151200_h((JsonObject)json, (String)"name"));
        }
    }
}

