/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.function;

import com.ferreusveritas.dynamictrees.loot.DTLootParameters;
import com.ferreusveritas.dynamictrees.loot.function.DTLootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;

public final class MultiplySticksCount
extends LootFunction {
    public MultiplySticksCount(ILootCondition[] conditions) {
        super(conditions);
    }

    public LootFunctionType func_230425_b_() {
        return DTLootFunctions.MULTIPLY_STICKS_COUNT;
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Integer volume = (Integer)context.func_216031_c(DTLootParameters.VOLUME);
        assert (volume != null);
        stack.func_190920_e(stack.func_190916_E() * 8 * (volume % 4096) / 4096);
        return stack;
    }

    public static ILootFunction.IBuilder multiplySticksCount() {
        return () -> new MultiplySticksCount(new ILootCondition[0]);
    }

    public static class Serializer
    extends LootFunction.Serializer<MultiplySticksCount> {
        public void serialize(JsonObject json, MultiplySticksCount value, JsonSerializationContext context) {
            super.func_230424_a_(json, (LootFunction)value, context);
        }

        public MultiplySticksCount deserialize(JsonObject json, JsonDeserializationContext context, ILootCondition[] conditions) {
            return new MultiplySticksCount(conditions);
        }
    }
}

