/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.bakedmodels;

import com.ferreusveritas.dynamictrees.blocks.branches.BasicBranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.models.bakedmodels.BranchBlockBakedModel;
import com.ferreusveritas.dynamictrees.models.modeldata.ModelConnections;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class BasicBranchBlockBakedModel
extends BranchBlockBakedModel {
    protected TextureAtlasSprite barkTexture;
    protected TextureAtlasSprite ringsTexture;
    private final IBakedModel[][] sleeves = new IBakedModel[6][7];
    private final IBakedModel[][] cores = new IBakedModel[3][8];
    private final IBakedModel[] rings = new IBakedModel[8];

    public BasicBranchBlockBakedModel(ResourceLocation modelResLoc, ResourceLocation barkResLoc, ResourceLocation ringsResLoc) {
        super(modelResLoc, barkResLoc, ringsResLoc);
    }

    @Override
    public void setupModels() {
        this.barkTexture = ModelUtils.getTexture(this.barkResLoc);
        this.ringsTexture = ModelUtils.getTexture(this.ringsResLoc);
        for (int i = 0; i < 8; ++i) {
            int radius = i + 1;
            if (radius < 8) {
                for (Direction dir : Direction.values()) {
                    this.sleeves[dir.func_176745_a()][i] = this.bakeSleeve(radius, dir, this.barkTexture);
                }
            }
            this.cores[0][i] = this.bakeCore(radius, Direction.Axis.Y, this.barkTexture);
            this.cores[1][i] = this.bakeCore(radius, Direction.Axis.Z, this.barkTexture);
            this.cores[2][i] = this.bakeCore(radius, Direction.Axis.X, this.barkTexture);
            this.rings[i] = this.bakeCore(radius, Direction.Axis.Y, this.ringsTexture);
        }
    }

    public IBakedModel bakeSleeve(int radius, Direction dir, TextureAtlasSprite bark) {
        boolean negative;
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.func_82601_c() != 0 ? halfSize : dradius;
        int halfSizeY = dir.func_96559_d() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.func_82599_e() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.func_82601_c() * move;
        int centerY = 16 + dir.func_96559_d() * move;
        int centerZ = 16 + dir.func_82599_e() * move;
        Vector3f posFrom = new Vector3f((float)(centerX - halfSizeX) / 2.0f, (float)(centerY - halfSizeY) / 2.0f, (float)(centerZ - halfSizeZ) / 2.0f);
        Vector3f posTo = new Vector3f((float)(centerX + halfSizeX) / 2.0f, (float)(centerY + halfSizeY) / 2.0f, (float)(centerZ + halfSizeZ) / 2.0f);
        boolean bl = negative = dir.func_176743_c() == Direction.AxisDirection.NEGATIVE;
        if (dir.func_176740_k() == Direction.Axis.Z) {
            negative = !negative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            if (dir.func_176734_d() == face) continue;
            BlockFaceUV uvface = null;
            if (dir == face) {
                if (radius == 1) {
                    uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
                }
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, negative ? (float)(16 - halfSize) : 0.0f, 8 + radius, negative ? 16.0f : (float)halfSize}, this.getFaceAngle(dir.func_176740_k(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(bark);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad(part, (BlockPartFace)e.getValue(), bark, face, ModelRotation.X0_Y0, this.modelResLoc));
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeCore(int radius, Direction.Axis axis, TextureAtlasSprite icon) {
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, this.getFaceAngle(axis, face));
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(icon);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad(part, (BlockPartFace)e.getValue(), icon, face, ModelRotation.X0_Y0, this.modelResLoc));
        }
        return builder.func_177645_b();
    }

    public int getFaceAngle(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return 0;
        }
        if (axis == Direction.Axis.Z) {
            switch (face) {
                case UP: {
                    return 0;
                }
                case WEST: {
                    return 270;
                }
                case DOWN: {
                    return 180;
                }
            }
            return 90;
        }
        return face == Direction.NORTH ? 270 : 90;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(24);
        int coreRadius = this.getRadius(state);
        if (coreRadius > 8) {
            return Collections.emptyList();
        }
        int[] connections = new int[]{0, 0, 0, 0, 0, 0};
        Direction forceRingDir = null;
        AtomicInteger twigRadius = new AtomicInteger(1);
        if (extraData instanceof ModelConnections) {
            ModelConnections connectionsData = (ModelConnections)extraData;
            connections = connectionsData.getAllRadii();
            forceRingDir = connectionsData.getRingOnly();
            connectionsData.getFamily().ifValid(family -> twigRadius.set(family.getPrimaryThickness()));
        }
        int numConnections = 0;
        for (int i : connections) {
            numConnections += i != 0 ? 1 : 0;
        }
        if (numConnections == 0 && forceRingDir != null) {
            quadsList.addAll(this.rings[coreRadius - 1].getQuads(state, forceRingDir, rand, extraData));
        } else {
            Direction sourceDir = this.getSourceDir(coreRadius, connections);
            int coreDir = this.resolveCoreDir(sourceDir);
            Direction coreRingDir = numConnections == 1 && sourceDir != null ? sourceDir.func_176734_d() : null;
            for (Direction face : Direction.values()) {
                if (coreRadius != connections[face.func_176745_a()]) {
                    if (coreRingDir == null || coreRingDir != face) {
                        quadsList.addAll(this.cores[coreDir][coreRadius - 1].getQuads(state, face, rand, extraData));
                    } else {
                        quadsList.addAll(this.rings[coreRadius - 1].getQuads(state, face, rand, extraData));
                    }
                }
                if (coreRadius == 8) continue;
                for (Direction connDir : Direction.values()) {
                    int idx = connDir.func_176745_a();
                    int connRadius = connections[idx];
                    if (connRadius <= 0 || connRadius != twigRadius.get() && face == connDir) continue;
                    quadsList.addAll(this.sleeves[idx][connRadius - 1].getQuads(state, face, rand, extraData));
                }
            }
        }
        return quadsList;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        Block block = state.func_177230_c();
        if (!(block instanceof BranchBlock)) {
            return new ModelConnections();
        }
        return new ModelConnections(((BranchBlock)block).getConnectionData(world, pos, state)).setFamily(((BranchBlock)block).getFamily());
    }

    @Nullable
    protected Direction getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        Direction sourceDir = null;
        for (Direction dir : Direction.values()) {
            int connRadius = connections[dir.func_176745_a()];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(@Nullable Direction dir) {
        if (dir == null) {
            return 0;
        }
        return dir.func_176745_a() >> 1;
    }

    protected int getRadius(BlockState blockState) {
        return ((BasicBranchBlock)blockState.func_177230_c()).getRadius(blockState);
    }

    public boolean func_177555_b() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.barkTexture;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public boolean doesHandlePerspectives() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }
}

