/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.bakedmodels;

import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.models.bakedmodels.BasicBranchBlockBakedModel;
import com.ferreusveritas.dynamictrees.models.modeldata.ModelConnections;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class ThickBranchBlockBakedModel
extends BasicBranchBlockBakedModel {
    protected final ResourceLocation thickRingsResLoc;
    private final IBakedModel[] trunksBark = new IBakedModel[16];
    private final IBakedModel[] trunksTopBark = new IBakedModel[16];
    private final IBakedModel[] trunksTopRings = new IBakedModel[16];
    private final IBakedModel[] trunksBotRings = new IBakedModel[16];

    public ThickBranchBlockBakedModel(ResourceLocation modelResLoc, ResourceLocation barkResLoc, ResourceLocation ringsResLoc, ResourceLocation thickRingsResLoc) {
        super(modelResLoc, barkResLoc, ringsResLoc);
        this.thickRingsResLoc = thickRingsResLoc;
    }

    private boolean isTextureNull(@Nullable TextureAtlasSprite sprite) {
        return sprite == null || sprite.equals(ModelUtils.getTexture(new ResourceLocation("")));
    }

    @Override
    public void setupModels() {
        super.setupModels();
        TextureAtlasSprite thickRingsTexture = ModelUtils.getTexture(this.thickRingsResLoc);
        if (this.isTextureNull(thickRingsTexture)) {
            thickRingsTexture = this.ringsTexture;
        }
        for (int i = 0; i < 16; ++i) {
            int radius = i + 8 + 1;
            this.trunksBark[i] = this.bakeTrunkBark(radius, this.barkTexture, true);
            this.trunksTopBark[i] = this.bakeTrunkBark(radius, this.barkTexture, false);
            this.trunksTopRings[i] = this.bakeTrunkRings(radius, thickRingsTexture, Direction.UP);
            this.trunksBotRings[i] = this.bakeTrunkRings(radius, thickRingsTexture, Direction.DOWN);
        }
    }

    public IBakedModel bakeTrunkBark(int radius, TextureAtlasSprite bark, boolean side) {
        Direction[] directionArray;
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(bark);
        AxisAlignedBB wholeVolume = new AxisAlignedBB((double)(8 - radius), 0.0, (double)(8 - radius), (double)(8 + radius), 16.0, (double)(8 + radius));
        if (side) {
            directionArray = CoordUtils.HORIZONTALS;
        } else {
            Direction[] directionArray2 = new Direction[2];
            directionArray2[0] = Direction.UP;
            directionArray = directionArray2;
            directionArray2[1] = Direction.DOWN;
        }
        Direction[] run = directionArray;
        ArrayList<Vector3i> offsets = new ArrayList<Vector3i>();
        for (CoordUtils.Surround surround : CoordUtils.Surround.values()) {
            offsets.add(surround.getOffset());
        }
        offsets.add(new Vector3i(0, 0, 0));
        for (CoordUtils.Surround surround : run) {
            Vector3i dirVector = surround.func_176730_m();
            for (Vector3i offset : offsets) {
                if (surround.func_176740_k() != Direction.Axis.Y) {
                    Vector3d vector3d = new Vector3d((double)dirVector.func_177958_n(), (double)dirVector.func_177956_o(), (double)dirVector.func_177952_p());
                    Vector3d vector3d2 = new Vector3d((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
                    if (!(vector3d.func_178787_e(vector3d2).func_189985_c() > 2.25)) continue;
                }
                Vector3d scaledOffset = new Vector3d((double)(offset.func_177958_n() * 16), (double)(offset.func_177956_o() * 16), (double)(offset.func_177952_p() * 16));
                AxisAlignedBB partBoundary = new AxisAlignedBB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).func_191194_a(scaledOffset).func_191500_a(wholeVolume);
                Vector3f[] limits = ModelUtils.AABBLimits(partBoundary);
                EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
                BlockFaceUV uvface = new BlockFaceUV(ModelUtils.modUV(ModelUtils.getUVs(partBoundary, (Direction)surround)), this.getFaceAngle(Direction.Axis.Y, (Direction)surround));
                mapFacesIn.put(surround, new BlockPartFace(null, -1, null, uvface));
                BlockPart part = new BlockPart(limits[0], limits[1], (Map)mapFacesIn, null, true);
                builder.func_177650_a((Direction)surround, ModelUtils.makeBakedQuad(part, (BlockPartFace)part.field_178240_c.get((Object)surround), bark, (Direction)surround, ModelRotation.X0_Y0, this.modelResLoc));
            }
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeTrunkRings(int radius, TextureAtlasSprite ring, Direction face) {
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(ring);
        AxisAlignedBB wholeVolume = new AxisAlignedBB((double)(8 - radius), 0.0, (double)(8 - radius), (double)(8 + radius), 16.0, (double)(8 + radius));
        int wholeVolumeWidth = 48;
        ArrayList<Vector3i> offsets = new ArrayList<Vector3i>();
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            offsets.add(dir.getOffset());
        }
        offsets.add(new Vector3i(0, 0, 0));
        for (Vector3i offset : offsets) {
            Vector3d scaledOffset = new Vector3d((double)(offset.func_177958_n() * 16), (double)(offset.func_177956_o() * 16), (double)(offset.func_177952_p() * 16));
            AxisAlignedBB partBoundary = new AxisAlignedBB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).func_191194_a(scaledOffset).func_191500_a(wholeVolume);
            Vector3f posFrom = new Vector3f((float)partBoundary.field_72340_a, (float)partBoundary.field_72338_b, (float)partBoundary.field_72339_c);
            Vector3f posTo = new Vector3f((float)partBoundary.field_72336_d, (float)partBoundary.field_72337_e, (float)partBoundary.field_72334_f);
            EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
            float textureOffsetX = -16.0f;
            float textureOffsetZ = -16.0f;
            float minX = (float)((partBoundary.field_72340_a - (double)textureOffsetX) / (double)wholeVolumeWidth) * 16.0f;
            float maxX = (float)((partBoundary.field_72336_d - (double)textureOffsetX) / (double)wholeVolumeWidth) * 16.0f;
            float minZ = (float)((partBoundary.field_72339_c - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
            float maxZ = (float)((partBoundary.field_72334_f - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
            if (face == Direction.DOWN) {
                minZ = (float)((partBoundary.field_72334_f - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
                maxZ = (float)((partBoundary.field_72339_c - (double)textureOffsetZ) / (double)wholeVolumeWidth) * 16.0f;
            }
            float[] uvs = new float[]{minX, minZ, maxX, maxZ};
            BlockFaceUV uvface = new BlockFaceUV(uvs, this.getFaceAngle(Direction.Axis.Y, face));
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
            BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
            builder.func_177650_a(face, ModelUtils.makeBakedQuad(part, (BlockPartFace)part.field_178240_c.get(face), ring, face, ModelRotation.X0_Y0, this.modelResLoc));
        }
        return builder.func_177645_b();
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        int coreRadius = this.getRadius(state);
        if (coreRadius <= 8) {
            return super.getQuads(state, null, rand, extraData);
        }
        coreRadius = MathHelper.func_76125_a((int)coreRadius, (int)9, (int)24);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(30);
        int[] connections = new int[]{0, 0, 0, 0, 0, 0};
        Direction forceRingDir = null;
        int twigRadius = 1;
        if (extraData instanceof ModelConnections) {
            ModelConnections connectionsData = (ModelConnections)extraData;
            connections = connectionsData.getAllRadii();
            forceRingDir = connectionsData.getRingOnly();
            Object family = connectionsData.getFamily();
            if (((RegistryEntry)family).isValid()) {
                twigRadius = ((Family)family).getPrimaryThickness();
            }
        }
        int numConnections = 0;
        for (int i : connections) {
            numConnections += i != false ? 1 : 0;
        }
        if (numConnections == 0 && forceRingDir != null) {
            return quads;
        }
        if (forceRingDir != null) {
            connections[forceRingDir.func_176745_a()] = 0;
            quads.addAll(this.trunksBotRings[coreRadius - 9].getQuads(state, forceRingDir, rand, extraData));
        }
        boolean branchesAround = connections[2] + connections[3] + connections[4] + connections[5] != 0;
        for (Direction face : Direction.values()) {
            quads.addAll(this.trunksBark[coreRadius - 9].getQuads(state, face, rand, extraData));
            if (face != Direction.UP && face != Direction.DOWN) continue;
            if (connections[face.func_176745_a()] < twigRadius && !branchesAround) {
                quads.addAll(this.trunksTopRings[coreRadius - 9].getQuads(state, face, rand, extraData));
                continue;
            }
            if (connections[face.func_176745_a()] >= coreRadius) continue;
            quads.addAll(this.trunksTopBark[coreRadius - 9].getQuads(state, face, rand, extraData));
        }
        return quads;
    }
}

