/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources;

import com.ferreusveritas.dynamictrees.api.resource.ResourceManager;
import com.ferreusveritas.dynamictrees.api.resource.TreeResourcePack;
import com.ferreusveritas.dynamictrees.api.resource.loading.ApplierResourceLoader;
import com.ferreusveritas.dynamictrees.api.resource.loading.ResourceLoader;
import com.ferreusveritas.dynamictrees.util.CommonCollectors;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.SimpleResource;
import net.minecraft.util.ResourceLocation;

public final class TreesResourceManager
implements IResourceManager,
ResourceManager {
    private final List<TreeResourcePack> resourcePacks = Lists.newArrayList();
    private final List<ResourceLoader<?>> resourceLoaders = Lists.newArrayList();
    private static final IResource NULL_RESOURCE = new SimpleResource(null, null, null, null);

    @Override
    public void addLoader(ResourceLoader<?> loader) {
        this.resourceLoaders.add(loader);
    }

    @Override
    public void addLoaders(ResourceLoader<?> ... loaders) {
        this.resourceLoaders.addAll(Arrays.asList(loaders));
    }

    @Override
    public void addLoaderBefore(ResourceLoader<?> loader, ResourceLoader<?> existing) {
        this.resourceLoaders.add(this.resourceLoaders.indexOf(existing), loader);
    }

    @Override
    public void addLoaderAfter(ResourceLoader<?> loader, ResourceLoader<?> existing) {
        this.resourceLoaders.add(this.resourceLoaders.indexOf(existing) + 1, loader);
    }

    @Override
    public void registerAppliers() {
        this.resourceLoaders.stream().filter(ApplierResourceLoader.class::isInstance).map(ApplierResourceLoader.class::cast).forEach(ApplierResourceLoader::registerAppliers);
    }

    @Override
    public void load() {
        this.resourceLoaders.forEach(loader -> loader.load(this).join());
    }

    @Override
    public void gatherData() {
        this.resourceLoaders.forEach(loader -> loader.gatherData(this).join());
    }

    @Override
    public void setup() {
        this.resourceLoaders.forEach(loader -> loader.setup(this).join());
    }

    @Override
    public CompletableFuture<?>[] prepareReload(Executor gameExecutor, Executor backgroundExecutor) {
        return (CompletableFuture[])this.resourceLoaders.stream().map(loader -> loader.prepareReload(this)).toArray(CompletableFuture[]::new);
    }

    @Override
    public void reload(CompletableFuture<?>[] futures) {
        for (int i = 0; i < futures.length; ++i) {
            this.reload(this.resourceLoaders.get(i), futures[i]);
        }
    }

    private <R> void reload(ResourceLoader<R> loader, CompletableFuture<?> future) {
        loader.reload(future, this);
    }

    @Override
    public void addPack(TreeResourcePack pack) {
        this.resourcePacks.add(pack);
    }

    public Set<String> func_199001_a() {
        return this.resourcePacks.stream().map(treeResourcePack -> treeResourcePack.func_195759_a(null)).flatMap(Collection::stream).collect(CommonCollectors.toLinkedSet());
    }

    public IResource func_199002_a(ResourceLocation location) throws IOException {
        List<IResource> resources = this.func_199004_b(location);
        if (resources.isEmpty()) {
            throw new FileNotFoundException("Could not find path '" + location + "' in any tree packs.");
        }
        return resources.get(resources.size() - 1);
    }

    public boolean func_219533_b(ResourceLocation path) {
        try {
            return !this.func_199004_b(path).isEmpty();
        }
        catch (IOException e) {
            return false;
        }
    }

    public List<IResource> func_199004_b(ResourceLocation path) throws IOException {
        return this.resourcePacks.stream().map(resourcePack -> this.getResource(path, (TreeResourcePack)resourcePack)).filter(resourcePack -> resourcePack != NULL_RESOURCE).collect(Collectors.toList());
    }

    private IResource getResource(ResourceLocation path, TreeResourcePack resourcePack) {
        InputStream stream;
        try {
            stream = resourcePack.getResource(path);
        }
        catch (IOException e) {
            return NULL_RESOURCE;
        }
        return new SimpleResource(resourcePack.func_195762_a(), path, stream, null);
    }

    private Stream<ResourceLocation> resourceLocationStream(String path, Predicate<String> filter) {
        return this.resourcePacks.stream().map(resourcePack -> resourcePack.getNamespaces().stream().map(namespace -> resourcePack.getResources((String)namespace, path, Integer.MAX_VALUE, filter)).flatMap(Collection::stream).collect(CommonCollectors.toLinkedSet())).flatMap(Collection::stream);
    }

    public Collection<ResourceLocation> func_199003_a(String path, Predicate<String> filter) {
        return this.resourceLocationStream(path, filter).collect(CommonCollectors.toAlternateLinkedSet());
    }

    @Override
    public Stream<IResourcePack> func_230232_b_() {
        return this.resourcePacks.stream().map(treeResourcePack -> treeResourcePack);
    }
}

