/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources.loader;

import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.JsonRegistryResourceLoader;
import com.ferreusveritas.dynamictrees.blocks.GrowableBlock;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.ResourceLocationDeserialiser;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.util.Null;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.shapes.VoxelShape;

public final class PodResourceLoader
extends JsonRegistryResourceLoader<Pod> {
    public PodResourceLoader() {
        super(Pod.REGISTRY, "pods");
    }

    @Override
    public void registerAppliers() {
        this.loadAppliers.register("max_age", Integer.class, Pod::setMaxAge);
        this.commonAppliers.register("block_shapes", JsonObject.class, this::readBlockShapes).register("item_stack", ItemStack.class, Pod::setItemStack);
        this.gatherDataAppliers.register("item_stack", ItemStack.class, Pod::setItemStack);
        this.reloadAppliers.register("can_bone_meal", Boolean.class, Pod::setCanBoneMeal).register("growth_chance", Float.class, Pod::setGrowthChance).register("season_offset", Float.class, Pod::setSeasonOffset).register("flower_hold_period_length", Float.class, Pod::setFlowerHoldPeriodLength).register("min_production_factor", Float.class, Pod::setMinProductionFactor).register("mature_action", GrowableBlock.MatureAction.class, Pod::setMatureAction);
        super.registerAppliers();
    }

    private void readBlockShapes(Pod pod, JsonObject json) {
        Direction.Plane.HORIZONTAL.func_239636_a_().forEach(facing -> {
            JsonElement shapeArrayElement = json.get(facing.func_176742_j().toLowerCase(Locale.ROOT));
            if (!shapeArrayElement.isJsonArray()) {
                return;
            }
            LinkedList shapes = new LinkedList();
            shapeArrayElement.getAsJsonArray().forEach(shapeElement -> JsonDeserialisers.VOXEL_SHAPE.deserialise(shapeElement).ifSuccess(shapes::add));
            pod.setBlockShapes((Direction)facing, shapes.toArray(new VoxelShape[0]));
        });
    }

    @Override
    protected void applyLoadAppliers(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        super.applyLoadAppliers(loadData, json);
        JsonObject propertiesJson = this.getBlockPropertiesJson(json);
        if (propertiesJson == null) {
            this.createBlock((Pod)loadData.getResource(), json);
        } else {
            this.createBlock((Pod)loadData.getResource(), json, propertiesJson);
        }
    }

    @Nullable
    private JsonObject getBlockPropertiesJson(JsonObject json) {
        return Null.applyIfNonnull(json.get("block_properties"), element -> JsonDeserialisers.JSON_OBJECT.deserialise(element).orElse(null));
    }

    private void createBlock(Pod pod, JsonObject json) {
        pod.createBlock(this.getBlockRegistryName(pod, json), pod.getDefaultBlockProperties());
    }

    private void createBlock(Pod pod, JsonObject json, JsonObject propertiesJson) {
        AbstractBlock.Properties blockProperties = JsonHelper.getBlockProperties(propertiesJson, pod.getDefaultMaterial(), pod.getDefaultMaterialColor(), pod::getDefaultBlockProperties, error -> this.logError(pod.getRegistryName(), (String)error), warning -> this.logWarning(pod.getRegistryName(), (String)warning));
        pod.createBlock(this.getBlockRegistryName(pod, json), blockProperties);
    }

    @Nullable
    private ResourceLocation getBlockRegistryName(Pod pod, JsonObject json) {
        return Null.applyIfNonnull(json.get("block_registry_name"), element -> ResourceLocationDeserialiser.create(pod.getRegistryName().func_110624_b()).deserialise((JsonElement)element).orElse(null));
    }
}

