/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.fruit;

import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.FruitBlock;
import com.ferreusveritas.dynamictrees.blocks.GrowableBlock;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.trees.Resettable;
import com.ferreusveritas.dynamictrees.util.AgeProperties;
import com.ferreusveritas.dynamictrees.util.LazyValue;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTable;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class Fruit
extends RegistryEntry<Fruit>
implements Resettable<Fruit> {
    public static final TypedRegistry.EntryType<Fruit> TYPE = TypedRegistry.newType(Fruit::new);
    public static final Fruit NULL = new Fruit(DTTrees.NULL);
    public static final TypedRegistry<Fruit> REGISTRY = new TypedRegistry<Fruit>(Fruit.class, NULL, TYPE);
    private FruitBlock block;
    private int maxAge = 3;
    private IntegerProperty ageProperty = BlockStateProperties.field_208168_U;
    private VoxelShape[] blockShapes = new VoxelShape[]{VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b()};
    private boolean canBoneMeal;
    private ItemStack itemStack;
    private float growthChance = 0.2f;
    @Nullable
    private Float seasonOffset = Float.valueOf(0.0f);
    private float flowerHoldPeriodLength = 0.5f;
    private float minProductionFactor = 0.3f;
    private GrowableBlock.MatureAction matureAction = GrowableBlock.MatureAction.DEFAULT;
    private final LazyValue<ResourceLocation> blockDropsPath = LazyValue.supplied(() -> ResourceLocationUtils.prefix(this.block.getRegistryName(), "blocks/"));

    public Fruit(ResourceLocation registryName) {
        super(registryName);
    }

    public final FruitBlock getBlock() {
        if (this.block == null) {
            throw new IllegalStateException("Invoked too early (before the block was created).");
        }
        return this.block;
    }

    public final void createBlock(@Nullable ResourceLocation name, AbstractBlock.Properties properties) {
        this.block = RegistryHandler.addBlock(name == null ? this.getRegistryName() : name, this.createBlock(properties));
    }

    protected FruitBlock createBlock(AbstractBlock.Properties properties) {
        return new FruitBlock(properties, this);
    }

    public Material getDefaultMaterial() {
        return Material.field_151585_k;
    }

    public MaterialColor getDefaultMaterialColor() {
        return this.getDefaultMaterial().func_151565_r();
    }

    public AbstractBlock.Properties getDefaultBlockProperties() {
        return this.getDefaultBlockProperties(this.getDefaultMaterial(), this.getDefaultMaterialColor());
    }

    public AbstractBlock.Properties getDefaultBlockProperties(Material material, MaterialColor materialColor) {
        return AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200947_a(SoundType.field_222472_s).func_200944_c().func_200943_b(0.3f);
    }

    public final IntegerProperty getAgeProperty() {
        return this.ageProperty;
    }

    public final int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        this.ageProperty = AgeProperties.getOrCreate(maxAge);
    }

    public final VoxelShape getBlockShape(int age) {
        return this.blockShapes[age];
    }

    public void setBlockShapes(VoxelShape[] blockShapes) {
        if (blockShapes.length <= this.maxAge) {
            throw new IllegalArgumentException("Insufficient number of block shapes provided for the maximum age " + this.maxAge + " on fruit " + this);
        }
        this.blockShapes = blockShapes;
    }

    public final boolean canBoneMeal() {
        return this.canBoneMeal;
    }

    public void setCanBoneMeal(boolean canBoneMeal) {
        this.canBoneMeal = canBoneMeal;
    }

    public final ItemStack getItemStack() {
        return this.itemStack.func_77946_l();
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public final float getGrowthChance() {
        return this.growthChance;
    }

    public void setGrowthChance(float growthChance) {
        this.growthChance = growthChance;
    }

    public final boolean isInFlowerHoldPeriod(IWorld world, BlockPos rootPos, Float seasonValue) {
        if (this.seasonOffset == null) {
            return false;
        }
        Float peakSeasonValue = SeasonHelper.getSeasonManager().getPeakFruitProductionSeasonValue(WorldContext.create(world).level(), rootPos, this.seasonOffset.floatValue());
        if (peakSeasonValue == null || this.flowerHoldPeriodLength == 0.0f) {
            return false;
        }
        float min = peakSeasonValue.floatValue() - 1.5f;
        float max = min + this.flowerHoldPeriodLength;
        return SeasonHelper.isSeasonBetween(seasonValue, min, max);
    }

    @Nullable
    public final Float getSeasonOffset() {
        return this.seasonOffset;
    }

    public void setSeasonOffset(@Nullable Float offset) {
        this.seasonOffset = offset;
    }

    public float seasonalFruitProductionFactor(WorldContext worldContext, BlockPos pos) {
        return this.seasonOffset != null ? SeasonHelper.globalSeasonalFruitProductionFactor(worldContext, pos, -this.seasonOffset.floatValue(), false) : 1.0f;
    }

    public float getFlowerHoldPeriodLength() {
        return this.flowerHoldPeriodLength;
    }

    public void setFlowerHoldPeriodLength(float flowerHoldPeriodLength) {
        this.flowerHoldPeriodLength = flowerHoldPeriodLength;
    }

    public final float getMinProductionFactor() {
        return this.minProductionFactor;
    }

    public void setMinProductionFactor(float minProductionFactor) {
        this.minProductionFactor = minProductionFactor;
    }

    public boolean isOutOfSeason(World world, BlockPos pos) {
        return this.seasonalFruitProductionFactor(WorldContext.create((IWorld)world), pos) < this.minProductionFactor;
    }

    public void place(IWorld world, BlockPos pos, @Nullable Float seasonValue) {
        BlockState state = this.getStateForAge(0);
        world.func_180501_a(pos, state, 3);
    }

    public void placeDuringWorldGen(IWorld world, BlockPos pos, @Nullable Float seasonValue) {
        BlockState state = this.getStateForAge(this.getAgeForWorldGen(world, pos, seasonValue));
        world.func_180501_a(pos, state, 3);
    }

    protected BlockState getStateForAge(int age) {
        if (age < 0) {
            throw new IllegalArgumentException("Cannot get state for negative fruit age.");
        }
        if (age > this.maxAge) {
            throw new IllegalArgumentException("Cannot get state for age " + age + " as it is greater than maximum " + this.maxAge + " for fruit \"" + this.getRegistryName() + "\".");
        }
        return (BlockState)this.block.func_176223_P().func_206870_a((Property)this.ageProperty, (Comparable)Integer.valueOf(age));
    }

    protected int getAgeForWorldGen(IWorld world, BlockPos pos, @Nullable Float seasonValue) {
        if (seasonValue != null && this.isInFlowerHoldPeriod(world, pos, seasonValue)) {
            return 0;
        }
        return Math.min(world.func_201674_k().nextInt(this.maxAge * 2), this.maxAge);
    }

    public void performMatureAction(GrowableBlock.Info blockInfo) {
        this.matureAction.perform(this.block, blockInfo);
    }

    public GrowableBlock.MatureAction getMatureAction() {
        return this.matureAction;
    }

    public void setMatureAction(GrowableBlock.MatureAction matureAction) {
        this.matureAction = matureAction;
    }

    public boolean shouldGenerateBlockDrops() {
        return true;
    }

    public ResourceLocation getBlockDropsPath() {
        return this.blockDropsPath.get();
    }

    public LootTable.Builder createBlockDrops() {
        return DTLootTableProvider.createFruitDrops(this.block, this.itemStack.func_77973_b(), this.ageProperty, this.maxAge);
    }

    @Override
    @Nonnull
    public Fruit reset() {
        this.canBoneMeal = (Boolean)DTConfigs.CAN_BONE_MEAL_FRUIT.get();
        this.seasonOffset = Float.valueOf(0.0f);
        this.flowerHoldPeriodLength = 0.5f;
        this.minProductionFactor = 0.3f;
        this.matureAction = GrowableBlock.MatureAction.DEFAULT;
        return this;
    }
}

