/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemappers.FindEndsNode;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;

public class AlternativeLeavesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<LeavesProperties> ALT_LEAVES = ConfigurationProperty.property("alternative_leaves", LeavesProperties.class);
    public static final ConfigurationProperty<Block> ALT_LEAVES_BLOCK = ConfigurationProperty.block("alternative_leaves_block");

    public AlternativeLeavesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(ALT_LEAVES, ALT_LEAVES_BLOCK, PLACE_CHANCE, QUANTITY);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(ALT_LEAVES, LeavesProperties.NULL)).with(ALT_LEAVES_BLOCK, Blocks.field_150350_a)).with(PLACE_CHANCE, Float.valueOf(0.5f))).with(QUANTITY, 5);
    }

    @Override
    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        configuration.get(ALT_LEAVES).ifValid(properties -> {
            properties.setFamily(species.getFamily());
            species.addValidLeafBlocks((LeavesProperties)properties);
        });
        return true;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockBounds bounds = context.species().getFamily().expandLeavesBlockBounds(new BlockBounds(context.endPoints()));
        return this.setAltLeaves(configuration, context.world(), bounds, context.bounds(), context.species());
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() == 0) {
            return false;
        }
        IWorld world = context.world();
        Species species = context.species();
        FindEndsNode endFinder = new FindEndsNode();
        TreeHelper.startAnalysisFromRoot(world, context.pos(), new MapSignal(endFinder));
        List<BlockPos> endPoints = endFinder.getEnds();
        if (endPoints.isEmpty()) {
            return false;
        }
        BlockPos chosenEndPoint = endPoints.get(world.func_201674_k().nextInt(endPoints.size()));
        BlockBounds bounds = species.getFamily().expandLeavesBlockBounds(new BlockBounds(chosenEndPoint));
        return this.setAltLeaves(configuration, world, bounds, SafeChunkBounds.ANY, species);
    }

    private Block getAltLeavesBlock(GenFeatureConfiguration conifuration) {
        LeavesProperties properties = conifuration.get(ALT_LEAVES);
        if (!properties.isValid() || !properties.getDynamicLeavesBlock().isPresent()) {
            return conifuration.get(ALT_LEAVES_BLOCK);
        }
        return (Block)properties.getDynamicLeavesBlock().get();
    }

    private BlockState getSwapBlockState(GenFeatureConfiguration configuration, IWorld world, Species species, BlockState state, boolean worldgen) {
        DynamicLeavesBlock altLeaves;
        DynamicLeavesBlock originalLeaves = species.getLeavesBlock().orElse(null);
        Block alt = this.getAltLeavesBlock(configuration);
        DynamicLeavesBlock dynamicLeavesBlock = altLeaves = alt instanceof DynamicLeavesBlock ? (DynamicLeavesBlock)alt : null;
        if (originalLeaves != null && altLeaves != null) {
            if (worldgen || world.func_201674_k().nextFloat() < ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
                if (state.func_177230_c() == originalLeaves) {
                    return altLeaves.field_235684_aB_.getDynamicLeavesState((Integer)state.func_177229_b((Property)LeavesBlock.field_208494_a));
                }
            } else if (state.func_177230_c() == altLeaves) {
                return originalLeaves.field_235684_aB_.getDynamicLeavesState((Integer)state.func_177229_b((Property)LeavesBlock.field_208494_a));
            }
        }
        return state;
    }

    private boolean setAltLeaves(GenFeatureConfiguration configuration, IWorld world, BlockBounds leafPositions, SafeChunkBounds safeBounds, Species species) {
        boolean worldGen;
        boolean bl = worldGen = safeBounds != SafeChunkBounds.ANY;
        if (worldGen) {
            AtomicBoolean isSet = new AtomicBoolean(false);
            leafPositions.iterator().forEachRemaining(pos -> {
                if (safeBounds.inBounds((BlockPos)pos, true) && world.func_201674_k().nextFloat() < ((Float)configuration.get(PLACE_CHANCE)).floatValue() && world.func_180501_a(pos, this.getSwapBlockState(configuration, world, species, world.func_180495_p(pos), true), 2)) {
                    isSet.set(true);
                }
            });
            return isSet.get();
        }
        boolean isSet = false;
        LinkedList<BlockPos> posList = new LinkedList<BlockPos>();
        for (BlockPos leafPosition : leafPositions) {
            posList.add(new BlockPos((Vector3i)leafPosition));
        }
        if (posList.isEmpty()) {
            return false;
        }
        for (int i = 0; i < (Integer)configuration.get(QUANTITY); ++i) {
            BlockPos pos2 = (BlockPos)posList.get(world.func_201674_k().nextInt(posList.size()));
            if (!world.func_180501_a(pos2, this.getSwapBlockState(configuration, world, species, world.func_180495_p(pos2), false), 2)) continue;
            isSet = true;
        }
        return isSet;
    }
}

