/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.util.function.BiomePredicate;
import net.minecraft.util.ResourceLocation;

public class BiomePredicateGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Boolean> ONLY_WORLD_GEN = ConfigurationProperty.bool("only_world_gen");
    public static final ConfigurationProperty<GenFeatureConfiguration> GEN_FEATURE = ConfigurationProperty.property("gen_feature", GenFeatureConfiguration.class);

    public BiomePredicateGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(BIOME_PREDICATE, GEN_FEATURE, ONLY_WORLD_GEN);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(BIOME_PREDICATE, i -> true)).with(GEN_FEATURE, GenFeatureConfiguration.getNull())).with(ONLY_WORLD_GEN, false);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        boolean worldGen = context.isWorldGen();
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        if (configuration.getGenFeature().getRegistryName().equals((Object)DTTrees.NULL)) {
            return false;
        }
        if ((!configuration.get(ONLY_WORLD_GEN).booleanValue() || worldGen) && ((BiomePredicate)configuration.get(BIOME_PREDICATE)).test(context.biome())) {
            return configurationToPlace.generate(GenFeature.Type.POST_GENERATION, context);
        }
        return false;
    }
}

