/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class BottomFlareGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MIN_RADIUS = ConfigurationProperty.integer("min_radius");

    public BottomFlareGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MIN_RADIUS);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)super.createDefaultConfiguration().with(MIN_RADIUS, 6);
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (context.fertility() > 0) {
            this.flareBottom(configuration, context.world(), context.pos(), context.species());
            return true;
        }
        return false;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        this.flareBottom(configuration, context.world(), context.pos(), context.species());
        return true;
    }

    public void flareBottom(GenFeatureConfiguration configuration, IWorld world, BlockPos rootPos, Species species) {
        Family family = species.getFamily();
        int radius3 = TreeHelper.getRadius((IBlockReader)world, rootPos.func_177981_b(3));
        if (radius3 > configuration.get(MIN_RADIUS)) {
            family.getBranch().ifPresent(branch -> {
                branch.setRadius(world, rootPos.func_177981_b(2), radius3 + 1, Direction.UP);
                branch.setRadius(world, rootPos.func_177981_b(1), radius3 + 2, Direction.UP);
            });
        }
    }
}

