/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;

public class ConiferTopperGenFeature
extends GenFeature {
    public static final ConfigurationProperty<LeavesProperties> LEAVES_PROPERTIES = ConfigurationProperty.property("leaves_properties", LeavesProperties.class);

    public ConiferTopperGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(LEAVES_PROPERTIES);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)super.createDefaultConfiguration().with(LEAVES_PROPERTIES, LeavesProperties.NULL);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (context.endPoints().isEmpty()) {
            return false;
        }
        IWorld world = context.world();
        BlockPos highest = Collections.max(context.endPoints(), Comparator.comparingInt(Vector3i::func_177956_o));
        LeavesProperties leavesProperties = configuration.get(LEAVES_PROPERTIES).elseIfInvalid(context.species().getLeavesProperties());
        world.func_180501_a(highest.func_177981_b(1), leavesProperties.getDynamicLeavesState(4), 3);
        world.func_180501_a(highest.func_177981_b(2), leavesProperties.getDynamicLeavesState(3), 3);
        world.func_180501_a(highest.func_177981_b(3), leavesProperties.getDynamicLeavesState(1), 3);
        return true;
    }
}

