/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemappers.FindEndsNode;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class FruitGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Fruit> FRUIT = ConfigurationProperty.property("fruit", Fruit.class);

    public FruitGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(FRUIT, VERTICAL_SPREAD, QUANTITY, RAY_DISTANCE, FRUITING_RADIUS, PLACE_CHANCE);
    }

    @Override
    public GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(FRUIT, Fruit.NULL)).with(VERTICAL_SPREAD, Float.valueOf(30.0f))).with(QUANTITY, 4)).with(FRUITING_RADIUS, 8)).with(PLACE_CHANCE, Float.valueOf(1.0f));
    }

    @Override
    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        return species.hasFruit(configuration.get(FRUIT));
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (!context.endPoints().isEmpty()) {
            int qty = (Integer)configuration.get(QUANTITY);
            qty = (int)((float)qty * context.fruitProductionFactor().floatValue());
            for (int i = 0; i < qty; ++i) {
                BlockPos endPoint = context.endPoints().get(context.random().nextInt(context.endPoints().size()));
                this.placeDuringWorldGen(configuration, context.species(), context.world(), context.pos().func_177984_a(), endPoint, context.bounds(), context.seasonValue());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        IWorld world = context.world();
        BlockState blockState = world.func_180495_p(context.treePos());
        BranchBlock branch = TreeHelper.getBranch(blockState);
        Fruit fruit = configuration.get(FRUIT);
        if (branch != null && branch.getRadius(blockState) >= (Integer)configuration.get(FRUITING_RADIUS) && context.natural()) {
            BlockPos rootPos = context.pos();
            float fruitingFactor = fruit.seasonalFruitProductionFactor(context.worldContext(), rootPos);
            if (fruitingFactor > fruit.getMinProductionFactor() && fruitingFactor > world.func_201674_k().nextFloat()) {
                FindEndsNode endFinder = new FindEndsNode();
                TreeHelper.startAnalysisFromRoot(world, rootPos, new MapSignal(endFinder));
                List<BlockPos> endPoints = endFinder.getEnds();
                int qty = (Integer)configuration.get(QUANTITY);
                if (!endPoints.isEmpty()) {
                    for (int i = 0; i < qty; ++i) {
                        BlockPos endPoint = endPoints.get(world.func_201674_k().nextInt(endPoints.size()));
                        this.place(configuration, context.species(), world, rootPos.func_177984_a(), endPoint, SeasonHelper.getSeasonValue(context.worldContext(), rootPos));
                    }
                }
            }
        }
        return true;
    }

    protected void place(GenFeatureConfiguration configuration, Species species, IWorld world, BlockPos treePos, BlockPos branchPos, Float seasonValue) {
        BlockPos fruitPos = CoordUtils.getRayTraceFruitPos(world, species, treePos, branchPos, SafeChunkBounds.ANY);
        if (this.shouldPlace(configuration, world, fruitPos)) {
            configuration.get(FRUIT).place(world, fruitPos, seasonValue);
        }
    }

    protected boolean shouldPlace(GenFeatureConfiguration configuration, IWorld world, BlockPos pos) {
        return pos != BlockPos.field_177992_a && (CoordUtils.coordHashCode(pos, 0) & 3) == 0 && world.func_201674_k().nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue();
    }

    protected void placeDuringWorldGen(GenFeatureConfiguration configuration, Species species, IWorld world, BlockPos treePos, BlockPos branchPos, SafeChunkBounds bounds, Float seasonValue) {
        BlockPos fruitPos = CoordUtils.getRayTraceFruitPos(world, species, treePos, branchPos, bounds);
        if (this.shouldPlaceDuringWorldGen(configuration, world, fruitPos)) {
            configuration.get(FRUIT).placeDuringWorldGen(world, fruitPos, seasonValue);
        }
    }

    protected boolean shouldPlaceDuringWorldGen(GenFeatureConfiguration configuration, IWorld world, BlockPos pos) {
        return pos != BlockPos.field_177992_a && world.func_201674_k().nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue();
    }
}

