/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.FullGenerationContext;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.google.common.collect.Iterables;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;

public class HugeMushroomGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> MUSHROOM_BLOCK = ConfigurationProperty.block("mushroom");
    public static final ConfigurationProperty<Block> STEM_BLOCK = ConfigurationProperty.block("stem");
    private int height = -1;
    static final SimpleVoxmap BROWN_CAP = new SimpleVoxmap(7, 1, 7, new byte[]{0, 1, 2, 2, 2, 3, 0, 1, 5, 5, 5, 5, 5, 3, 4, 5, 5, 5, 5, 5, 6, 4, 5, 5, 5, 5, 5, 6, 4, 5, 5, 5, 5, 5, 6, 7, 5, 5, 5, 5, 5, 9, 0, 7, 8, 8, 8, 9, 0}).setCenter(new BlockPos(3, 0, 3));
    static final SimpleVoxmap BROWN_CAP_MEDIUM = new SimpleVoxmap(5, 1, 5, new byte[]{0, 1, 2, 3, 0, 1, 5, 5, 5, 3, 4, 5, 5, 5, 6, 7, 5, 5, 5, 9, 0, 7, 8, 9, 0}).setCenter(new BlockPos(2, 0, 2));
    static final SimpleVoxmap BROWN_CAP_SMALL = new SimpleVoxmap(3, 1, 3, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}).setCenter(new BlockPos(1, 0, 1));
    static final SimpleVoxmap RED_CAP = new SimpleVoxmap(5, 4, 5, new byte[]{0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0, 4, 5, 6, 0, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 3, 2));
    static final SimpleVoxmap RED_CAP_SHORT = new SimpleVoxmap(5, 3, 5, new byte[]{0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 1, 2, 3, 0, 1, 0, 0, 0, 3, 4, 0, 10, 0, 6, 7, 0, 0, 0, 9, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0, 4, 5, 6, 0, 0, 7, 8, 9, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 2, 2));
    static final SimpleVoxmap RED_CAP_SMALL = new SimpleVoxmap(3, 2, 3, new byte[]{1, 2, 3, 4, 10, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8, 9}).setCenter(new BlockPos(1, 1, 1));

    public HugeMushroomGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MUSHROOM_BLOCK, STEM_BLOCK);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MUSHROOM_BLOCK, Blocks.field_150419_aX)).with(STEM_BLOCK, Blocks.field_196706_do);
    }

    public HugeMushroomGenFeature setHeight(int height) {
        this.height = height;
        return this;
    }

    protected SimpleVoxmap getCapForHeight(Block mushroomBlock, int height) {
        if (mushroomBlock == Blocks.field_150420_aW) {
            switch (height) {
                case 2: 
                case 3: {
                    return BROWN_CAP_SMALL;
                }
                case 4: 
                case 5: {
                    return BROWN_CAP_MEDIUM;
                }
            }
            return BROWN_CAP;
        }
        switch (height) {
            case 2: {
                return BROWN_CAP_SMALL;
            }
            case 3: {
                return RED_CAP_SMALL;
            }
            case 4: {
                return RED_CAP_SHORT;
            }
        }
        return RED_CAP;
    }

    protected int getMushroomHeight(IWorld world, BlockPos rootPos, Biome biome, Random random, int radius, SafeChunkBounds safeBounds) {
        return this.height > 0 ? this.height : random.nextInt(9) + 2;
    }

    @Override
    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        IWorld world = context.world();
        BlockPos rootPos = context.pos();
        BlockPos genPos = rootPos.func_177984_a();
        int height = this.getMushroomHeight(world, rootPos, context.biome(), context.random(), context.radius(), context.bounds());
        BlockState soilState = world.func_180495_p(rootPos);
        if (context.species().isAcceptableSoilForWorldgen(world, rootPos, soilState)) {
            Block mushroomBlock = configuration.get(MUSHROOM_BLOCK);
            if (mushroomBlock == null) {
                mushroomBlock = context.random().nextBoolean() ? Blocks.field_150420_aW : Blocks.field_150419_aX;
            }
            SimpleVoxmap capMap = this.getCapForHeight(mushroomBlock, height);
            BlockPos capPos = genPos.func_177981_b(height - 1);
            BlockBounds capBounds = capMap.getBounds().move(capPos);
            if (context.bounds().inBounds(capBounds, true)) {
                for (Object mutPos : Iterables.concat((Iterable)BlockPos.func_218278_a((BlockPos)BlockPos.field_177992_a.func_177979_c(capMap.getLenY()), (BlockPos)BlockPos.field_177992_a.func_177979_c(height - 1)), capMap.getAllNonZero())) {
                    BlockPos dPos = mutPos.func_177971_a((Vector3i)capPos);
                    BlockState state = world.func_180495_p(dPos);
                    if (state.func_185904_a().func_76222_j()) continue;
                    return true;
                }
                BlockState stemState = configuration.get(STEM_BLOCK).func_176223_P();
                for (SimpleVoxmap.Cell cell : capMap.getAllNonZeroCells()) {
                    world.func_180501_a(capPos.func_177971_a((Vector3i)cell.getPos()), this.getMushroomStateForValue(mushroomBlock, stemState, cell.getValue(), cell.getPos().func_177956_o()), 2);
                }
                int stemLen = height - capMap.getLenY();
                for (int y = 0; y < stemLen; ++y) {
                    world.func_180501_a(genPos.func_177981_b(y), stemState, 2);
                }
                return true;
            }
        }
        return true;
    }

    protected BlockState getMushroomStateForValue(Block mushroomBlock, BlockState stemBlock, int value, int y) {
        if (value == 10) {
            return stemBlock;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)mushroomBlock.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(y >= -1))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(value >= 1 && value <= 3))).func_206870_a((Property)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(value >= 7 && value <= 9))).func_206870_a((Property)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(value == 1 || value == 4 || value == 7))).func_206870_a((Property)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(value % 3 == 0));
    }
}

