/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PreGenerationContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;

public class MoundGenFeature
extends GenFeature {
    private static final SimpleVoxmap moundMap = new SimpleVoxmap(5, 4, 5, new byte[]{0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 0, 0, 1, 1, 1, 0, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 1, 2, 2, 2, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 3, 2));
    public static final ConfigurationProperty<Integer> MOUND_CUTOFF_RADIUS = ConfigurationProperty.integer("mound_cutoff_radius");

    public MoundGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MOUND_CUTOFF_RADIUS);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)super.createDefaultConfiguration().with(MOUND_CUTOFF_RADIUS, 5);
    }

    @Override
    protected BlockPos preGenerate(GenFeatureConfiguration configuration, PreGenerationContext context) {
        IWorld world = context.world();
        BlockPos rootPos = context.pos();
        if (context.radius() >= configuration.get(MOUND_CUTOFF_RADIUS) && context.isWorldGen()) {
            BlockState initialDirtState = world.func_180495_p(rootPos);
            BlockState initialUnderState = world.func_180495_p(rootPos.func_177977_b());
            if (initialUnderState.func_185904_a() == Material.field_151579_a || initialUnderState.func_185904_a() != Material.field_151578_c && initialUnderState.func_185904_a() != Material.field_151576_e) {
                Biome biome = world.func_225604_a_(rootPos.func_177958_n() >> 2, rootPos.func_177956_o() >> 2, rootPos.func_177952_p() >> 2);
                initialUnderState = biome.func_242440_e().func_242502_e().func_204108_a();
            }
            rootPos = rootPos.func_177984_a();
            for (SimpleVoxmap.Cell cell : moundMap.getAllNonZeroCells()) {
                BlockState placeState = cell.getValue() == 1 ? initialDirtState : initialUnderState;
                world.func_180501_a(rootPos.func_177971_a((Vector3i)cell.getPos()), placeState, 3);
            }
        }
        return rootPos;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (context.radius() >= configuration.get(MOUND_CUTOFF_RADIUS) || !context.isWorldGen()) {
            return false;
        }
        IWorld world = context.world();
        BlockPos rootPos = context.pos();
        BlockPos treePos = rootPos.func_177984_a();
        BlockState belowState = world.func_180495_p(rootPos.func_177977_b());
        BlockState branchState = world.func_180495_p(treePos);
        if (TreeHelper.getTreePart(branchState).getRadius(branchState) > 8) {
            for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
                BlockPos dPos = rootPos.func_177971_a(dir.getOffset());
                world.func_180501_a(dPos, context.initialDirtState(), 3);
                world.func_180501_a(dPos.func_177977_b(), belowState, 3);
            }
            return true;
        }
        return false;
    }
}

