/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import net.minecraft.util.ResourceLocation;

public class RandomPredicateGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Boolean> ONLY_WORLD_GEN = ConfigurationProperty.bool("only_world_gen");
    public static final ConfigurationProperty<GenFeatureConfiguration> GEN_FEATURE = ConfigurationProperty.property("gen_feature", GenFeatureConfiguration.class);

    public RandomPredicateGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(PLACE_CHANCE, GEN_FEATURE, ONLY_WORLD_GEN);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(PLACE_CHANCE, Float.valueOf(0.5f))).with(GEN_FEATURE, GenFeatureConfiguration.getNull())).with(ONLY_WORLD_GEN, false);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (configuration.get(ONLY_WORLD_GEN).booleanValue() && !context.isWorldGen() || Math.abs((float)CoordUtils.coordHashCode(context.pos(), 2) / 65535.0f) > ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            return false;
        }
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        return configuration.getGenFeature().isValid() && configurationToPlace.getGenFeature().postGenerate(configurationToPlace, context);
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (configuration.get(ONLY_WORLD_GEN).booleanValue() || Math.abs((float)CoordUtils.coordHashCode(context.pos(), 2) / 65535.0f) > ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            return false;
        }
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        return configuration.getGenFeature().isValid() && configurationToPlace.getGenFeature().postGrow(configurationToPlace, context);
    }
}

