/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.function.CanGrowPredicate;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class ShroomlightGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Block> SHROOMLIGHT_BLOCK = ConfigurationProperty.block("shroomlight");
    private static final Direction[] HORIZONTALS = CoordUtils.HORIZONTALS;
    private static final double VANILLA_GROW_CHANCE = (double)0.005f;

    public ShroomlightGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(SHROOMLIGHT_BLOCK, MAX_HEIGHT, CAN_GROW_PREDICATE, PLACE_CHANCE, MAX_COUNT);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(SHROOMLIGHT_BLOCK, Blocks.field_235383_mw_)).with(MAX_HEIGHT, 32)).with(CAN_GROW_PREDICATE, (world, blockPos) -> (double)world.func_201674_k().nextFloat() <= (double)0.005f)).with(PLACE_CHANCE, Float.valueOf(0.4f))).with(MAX_COUNT, 4);
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        return this.placeShroomlightsInValidPlace(configuration, context.world(), context.pos(), true);
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        return context.natural() && ((CanGrowPredicate)configuration.get(CAN_GROW_PREDICATE)).test(context.world(), context.pos().func_177984_a()) && context.fertility() != 0 && this.placeShroomlightsInValidPlace(configuration, context.world(), context.pos(), false);
    }

    private boolean placeShroomlightsInValidPlace(GenFeatureConfiguration configuration, IWorld world, BlockPos rootPos, boolean worldGen) {
        int treeHeight = this.getTreeHeight(world, rootPos, (Integer)configuration.get(MAX_HEIGHT));
        Block shroomlightBlock = configuration.get(SHROOMLIGHT_BLOCK);
        List<BlockPos> validSpaces = this.findBranchPits(configuration, world, rootPos, treeHeight);
        if (validSpaces == null) {
            return false;
        }
        if (validSpaces.size() > 0) {
            if (worldGen) {
                int placed = 0;
                for (BlockPos chosenSpace : validSpaces) {
                    if (!(world.func_201674_k().nextFloat() <= ((Float)configuration.get(PLACE_CHANCE)).floatValue())) continue;
                    world.func_180501_a(chosenSpace, shroomlightBlock.func_176223_P(), 2);
                    if (++placed <= (Integer)configuration.get(MAX_COUNT)) continue;
                    break;
                }
            } else {
                BlockPos chosenSpace = validSpaces.get(world.func_201674_k().nextInt(validSpaces.size()));
                world.func_180501_a(chosenSpace, shroomlightBlock.func_176223_P(), 2);
            }
            return true;
        }
        return false;
    }

    private int getTreeHeight(IWorld world, BlockPos rootPos, int maxHeight) {
        for (int i = 1; i < maxHeight; ++i) {
            if (TreeHelper.isBranch(world.func_180495_p(rootPos.func_177981_b(i)))) continue;
            return i - 1;
        }
        return maxHeight;
    }

    @Nullable
    private List<BlockPos> findBranchPits(GenFeatureConfiguration configuration, IWorld world, BlockPos rootPos, int maxHeight) {
        int existingBlocks = 0;
        LinkedList<BlockPos> validSpaces = new LinkedList<BlockPos>();
        for (int y = 2; y < maxHeight; ++y) {
            BlockPos trunkPos = rootPos.func_177981_b(y);
            for (Direction dir : HORIZONTALS) {
                BlockPos sidePos = trunkPos.func_177972_a(dir);
                if ((world.func_175623_d(sidePos) || world.func_180495_p(sidePos).func_177230_c() instanceof DynamicLeavesBlock) && TreeHelper.isBranch(world.func_180495_p(sidePos.func_177984_a()))) {
                    validSpaces.add(sidePos);
                    continue;
                }
                if (world.func_180495_p(sidePos).func_177230_c() != configuration.get(SHROOMLIGHT_BLOCK) || ++existingBlocks <= (Integer)configuration.get(MAX_COUNT)) continue;
                return null;
            }
        }
        return validSpaces;
    }
}

