/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.genfeatures;

import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class UndergrowthGenFeature
extends GenFeature {
    public UndergrowthGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        boolean worldGen = context.isWorldGen();
        int radius = context.radius();
        if (!worldGen || radius <= 2) {
            return false;
        }
        IWorld world = context.world();
        BlockPos rootPos = context.pos();
        SafeChunkBounds bounds = context.bounds();
        Species species = context.species();
        Vector3d vTree = new Vector3d((double)rootPos.func_177958_n(), (double)rootPos.func_177956_o(), (double)rootPos.func_177952_p()).func_72441_c(0.5, 0.5, 0.5);
        for (int i = 0; i < 2; ++i) {
            int rad = MathHelper.func_76125_a((int)(world.func_201674_k().nextInt(radius - 2) + 2), (int)2, (int)(radius - 1));
            Vector3d v = vTree.func_178787_e(new Vector3d(1.0, 0.0, 0.0).func_186678_a((double)rad).func_178785_b((float)((double)world.func_201674_k().nextFloat() * Math.PI * 2.0)));
            BlockPos vPos = new BlockPos(v);
            if (!bounds.inBounds(vPos, true)) continue;
            BlockPos groundPos = CoordUtils.findWorldSurface(world, vPos, true);
            BlockState soilBlockState = world.func_180495_p(groundPos);
            BlockPos pos = groundPos.func_177984_a();
            if (!species.isAcceptableSoil((IWorldReader)world, groundPos, soilBlockState)) continue;
            int type = world.func_201674_k().nextInt(2);
            world.func_180501_a(pos, (type == 0 ? Blocks.field_196617_K : Blocks.field_196620_N).func_176223_P(), 2);
            pos = pos.func_177981_b(world.func_201674_k().nextInt(3));
            BlockState leavesState = (BlockState)(type == 0 ? Blocks.field_196642_W : Blocks.field_196648_Z).func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
            SimpleVoxmap leafMap = species.getLeavesProperties().getCellKit().getLeafCluster();
            BlockPos.Mutable leafPos = new BlockPos.Mutable();
            for (BlockPos.Mutable dPos : leafMap.getAllNonZero()) {
                leafPos.func_181079_c(pos.func_177958_n() + dPos.func_177958_n(), pos.func_177956_o() + dPos.func_177956_o(), pos.func_177952_p() + dPos.func_177952_p());
                if (!bounds.inBounds((BlockPos)leafPos, true) || CoordUtils.coordHashCode((BlockPos)leafPos, 0) % 5 == 0 || !world.func_180495_p((BlockPos)leafPos).canBeReplacedByLeaves((IWorldReader)world, (BlockPos)leafPos) && !world.func_180495_p((BlockPos)leafPos).func_235714_a_(DTBlockTags.FOLIAGE)) continue;
                world.func_180501_a((BlockPos)leafPos, leavesState, 2);
            }
        }
        return true;
    }
}

