/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class DenuderNode
implements NodeInspector {
    private final Species species;
    private final Family family;

    public DenuderNode(Species species, Family family) {
        this.species = species;
        this.family = family;
    }

    @Override
    public boolean run(BlockState state, IWorld world, BlockPos pos, Direction fromDir) {
        BranchBlock branch = TreeHelper.getBranch(state);
        if (branch == null || this.family.getBranch().map(other -> branch != other).orElse(false).booleanValue()) {
            return false;
        }
        int radius = branch.getRadius(state);
        branch.stripBranch(state, world, pos, radius);
        if (radius <= this.family.getPrimaryThickness()) {
            this.removeSurroundingLeaves(world, pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        return false;
    }

    public void removeSurroundingLeaves(IWorld world, BlockPos twigPos) {
        if (world.func_201670_d()) {
            return;
        }
        SimpleVoxmap leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
        int xBound = leafCluster.getLenX();
        int yBound = leafCluster.getLenY();
        int zBound = leafCluster.getLenZ();
        BlockPos.func_218281_b((BlockPos)twigPos.func_177982_a(-xBound, -yBound, -zBound), (BlockPos)twigPos.func_177982_a(xBound, yBound, zBound)).forEach(testPos -> {
            if (leafCluster.getVoxel(twigPos, (BlockPos)testPos) == 0) {
                return;
            }
            BlockState state = world.func_180495_p(testPos);
            if (this.family.isCompatibleGenericLeaves(this.species, state, world, (BlockPos)testPos)) {
                world.func_180501_a(testPos, BlockStates.AIR, 3);
            }
        });
    }
}

