/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class FreezerNode
implements NodeInspector {
    private final Species species;
    private static final int freezeRadius = 3;

    public FreezerNode(Species species) {
        this.species = species;
    }

    @Override
    public boolean run(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        int radius;
        BranchBlock branch = TreeHelper.getBranch(blockState);
        if (branch != null && (radius = branch.getRadius(blockState)) == 1) {
            this.freezeSurroundingLeaves(world, branch, pos);
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        return false;
    }

    public void freezeSurroundingLeaves(IWorld world, BranchBlock branch, BlockPos twigPos) {
        if (world.func_201670_d()) {
            return;
        }
        Family tree = branch.getFamily();
        BlockPos.func_218281_b((BlockPos)twigPos.func_177982_a(-3, -3, -3), (BlockPos)twigPos.func_177982_a(3, 3, 3)).forEach(leavesPos -> {
            if (!tree.isCompatibleGenericLeaves(this.species, world.func_180495_p(leavesPos), world, (BlockPos)leavesPos)) {
                return;
            }
            BlockState state = world.func_180495_p(leavesPos);
            DynamicLeavesBlock leaves = TreeHelper.getLeaves(state);
            if (leaves == null) {
                return;
            }
            world.func_180501_a(leavesPos, (BlockState)leaves.getProperties(state).getPrimitiveLeaves().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true)), 2);
        });
    }
}

