/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class InflatorNode
implements NodeInspector {
    private float radius;
    private BlockPos last;
    private BlockPos highestTrunkBlock;
    Species species;
    SimpleVoxmap leafMap;

    public InflatorNode(Species species, SimpleVoxmap leafMap) {
        this.species = species;
        this.leafMap = leafMap;
        this.last = BlockPos.field_177992_a;
        this.highestTrunkBlock = null;
    }

    @Override
    public boolean run(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        BranchBlock branch = TreeHelper.getBranch(blockState);
        if (branch != null) {
            this.radius = this.species.getFamily().getPrimaryThickness();
            if (this.highestTrunkBlock == null && !TreeHelper.isBranch(world.func_180495_p(pos.func_177984_a()))) {
                this.highestTrunkBlock = pos;
            }
        }
        return false;
    }

    @Override
    public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        BranchBlock branch = TreeHelper.getBranch(blockState);
        if (branch != null) {
            float areaAccum = this.radius * this.radius;
            boolean isTwig = true;
            for (Direction dir : Direction.values()) {
                if (dir.equals((Object)fromDir)) continue;
                BlockPos dPos = pos.func_177972_a(dir);
                if (dPos.equals((Object)this.last)) {
                    isTwig = false;
                    continue;
                }
                BlockState deltaBlockState = world.func_180495_p(dPos);
                TreePart treepart = TreeHelper.getTreePart(deltaBlockState);
                if (!branch.isSameTree(treepart)) continue;
                int branchRadius = treepart.getRadius(deltaBlockState);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (isTwig) {
                if (this.leafMap != null) {
                    this.leafMap.setVoxel(pos, (byte)16);
                    SimpleVoxmap leafCluster = this.species.getLeavesProperties().getCellKit().getLeafCluster();
                    this.leafMap.blitMax(pos, leafCluster);
                }
            } else {
                float secondaryThickness;
                this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                int maxRadius = this.species.getMaxBranchRadius();
                if (this.radius > (float)maxRadius) {
                    this.radius = maxRadius;
                }
                if (this.highestTrunkBlock != null) {
                    boolean isInTrunk;
                    int blockRadius = 8;
                    boolean bl = isInTrunk = pos.func_177958_n() == this.highestTrunkBlock.func_177958_n() && pos.func_177956_o() <= this.highestTrunkBlock.func_177956_o() && pos.func_177952_p() == this.highestTrunkBlock.func_177952_p();
                    if (this.radius > (float)blockRadius && !isInTrunk) {
                        this.radius = blockRadius;
                    }
                }
                if (this.radius < (secondaryThickness = (float)this.species.getFamily().getSecondaryThickness())) {
                    this.radius = secondaryThickness;
                }
                branch.setRadius(world, pos, (int)Math.floor(this.radius), null);
                if (this.leafMap != null) {
                    this.leafMap.setVoxel(pos, (byte)32);
                }
            }
            this.last = pos;
        }
        return false;
    }
}

