/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class PodGenerationNode
implements NodeInspector {
    private final PodPlacer podPlacer;
    @Nullable
    private final Float seasonValue;
    private boolean finished = false;

    public PodGenerationNode(PodPlacer podPlacer, @Nullable Float seasonValue) {
        this.podPlacer = podPlacer;
        this.seasonValue = seasonValue;
    }

    @Override
    public boolean run(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        int hashCode;
        if (!this.finished && (hashCode = CoordUtils.coordHashCode(pos, 1)) % 97 % 29 == 0) {
            BranchBlock branch = TreeHelper.getBranch(blockState);
            if (branch != null && branch.getRadius(blockState) == 8) {
                int side = hashCode % 4 + 2;
                Direction dir = Direction.func_82600_a((int)side);
                BlockPos deltaPos = pos.func_177972_a(dir);
                if (world.func_175623_d(deltaPos)) {
                    if (!dir.func_176740_k().func_176722_c()) {
                        dir = Direction.NORTH;
                    }
                    this.podPlacer.place(world, deltaPos, this.seasonValue, dir.func_176734_d());
                }
            } else {
                this.finished = true;
            }
        }
        return false;
    }

    @Override
    public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        return false;
    }

    public static interface PodPlacer {
        public void place(IWorld var1, BlockPos var2, @Nullable Float var3, Direction var4);
    }
}

