/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class SpeciesNode
implements NodeInspector {
    private Species determination = Species.NULL_SPECIES;

    @Override
    public boolean run(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        TreePart treePart = TreeHelper.getTreePart(blockState);
        switch (treePart.getTreePartType()) {
            case BRANCH: {
                if (this.determination != Species.NULL_SPECIES) break;
                this.determination = TreeHelper.getBranch(treePart).getFamily().getCommonSpecies();
                break;
            }
            case ROOT: {
                this.determination = TreeHelper.getRooty(treePart).getSpecies(world.func_180495_p(pos), world, pos);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        return false;
    }

    public Species getSpecies() {
        return this.determination;
    }
}

