/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class TransformNode
implements NodeInspector {
    private final Species fromSpecies;
    private final Species toSpecies;
    private static final int TEST_LEAVES_RADIUS = 3;

    public TransformNode(Species fromTree, Species toTree) {
        this.fromSpecies = fromTree;
        this.toSpecies = toTree;
    }

    @Override
    public boolean run(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        int radius;
        BranchBlock branch = TreeHelper.getBranch(blockState);
        if (branch != null && this.fromSpecies.getFamily() == branch.getFamily() && (radius = branch.getRadius(blockState)) > 0) {
            BranchBlock newBranchBlock = this.toSpecies.getFamily().getBranch().orElse(null);
            if (this.fromSpecies.getFamily().getStrippedBranch().orElse(null) == branch) {
                newBranchBlock = this.toSpecies.getFamily().getStrippedBranch().get();
            }
            newBranchBlock.setRadius(world, pos, radius, null);
            if (radius == 1) {
                this.transformSurroundingLeaves(world, pos);
            }
        }
        return true;
    }

    @Override
    public boolean returnRun(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir) {
        return false;
    }

    public void transformSurroundingLeaves(IWorld world, BlockPos twigPos) {
        if (world.func_201670_d()) {
            return;
        }
        SimpleVoxmap leafCluster = this.fromSpecies.getLeavesProperties().getCellKit().getLeafCluster();
        int xBound = leafCluster.getLenX();
        int yBound = leafCluster.getLenY();
        int zBound = leafCluster.getLenZ();
        BlockPos.func_218281_b((BlockPos)twigPos.func_177982_a(-xBound, -yBound, -zBound), (BlockPos)twigPos.func_177982_a(xBound, yBound, zBound)).forEach(testPos -> {
            if (this.fromSpecies.getLeavesProperties().getCellKit().getLeafCluster().getVoxel(twigPos, (BlockPos)testPos) == 0) {
                return;
            }
            BlockState state = world.func_180495_p(testPos);
            if (this.fromSpecies.getFamily().isCompatibleGenericLeaves(this.fromSpecies, state, world, (BlockPos)testPos)) {
                int hydro = state.func_177230_c() instanceof DynamicLeavesBlock ? (Integer)state.func_177229_b((Property)DynamicLeavesBlock.field_208494_a) : 2;
                world.func_180501_a(testPos, this.toSpecies.getLeavesProperties().getDynamicLeavesState(hydro), 3);
            }
        });
    }
}

