/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.pod;

import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.GrowableBlock;
import com.ferreusveritas.dynamictrees.blocks.PodBlock;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.trees.Resettable;
import com.ferreusveritas.dynamictrees.util.AgeProperties;
import com.ferreusveritas.dynamictrees.util.LazyValue;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTable;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorld;

public class Pod
extends RegistryEntry<Pod>
implements Resettable<Pod> {
    public static final TypedRegistry.EntryType<Pod> TYPE = TypedRegistry.newType(Pod::new);
    public static final Pod NULL = new Pod(DTTrees.NULL);
    public static final TypedRegistry<Pod> REGISTRY = new TypedRegistry<Pod>(Pod.class, NULL, TYPE);
    private PodBlock block;
    private int maxAge = 2;
    private IntegerProperty ageProperty = BlockStateProperties.field_208167_T;
    private final BlockShapeData blockShapeData = new BlockShapeData();
    private boolean canBoneMeal = true;
    private ItemStack itemStack;
    private float growthChance = 0.2f;
    @Nullable
    private Float seasonOffset = Float.valueOf(0.0f);
    private float flowerHoldPeriodLength = 0.5f;
    private float minProductionFactor = 0.3f;
    private GrowableBlock.MatureAction matureAction = GrowableBlock.MatureAction.DEFAULT;
    private final LazyValue<ResourceLocation> blockDropsPath = LazyValue.supplied(() -> ResourceLocationUtils.prefix(this.block.getRegistryName(), "blocks/"));

    public Pod(ResourceLocation registryName) {
        super(registryName);
    }

    public final PodBlock getBlock() {
        if (this.block == null) {
            throw new IllegalStateException("Invoked too early (before the block was created).");
        }
        return this.block;
    }

    public final void createBlock(@Nullable ResourceLocation name, AbstractBlock.Properties properties) {
        this.block = RegistryHandler.addBlock(name == null ? this.getRegistryName() : name, this.createBlock(properties));
    }

    protected PodBlock createBlock(AbstractBlock.Properties properties) {
        return new PodBlock(properties, this);
    }

    public Material getDefaultMaterial() {
        return Material.field_151585_k;
    }

    public MaterialColor getDefaultMaterialColor() {
        return this.getDefaultMaterial().func_151565_r();
    }

    public AbstractBlock.Properties getDefaultBlockProperties() {
        return this.getDefaultBlockProperties(this.getDefaultMaterial(), this.getDefaultMaterialColor());
    }

    public AbstractBlock.Properties getDefaultBlockProperties(Material material, MaterialColor materialColor) {
        return AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200947_a(SoundType.field_222472_s).func_200944_c().func_200943_b(0.3f);
    }

    public final IntegerProperty getAgeProperty() {
        return this.ageProperty;
    }

    public final int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        this.ageProperty = AgeProperties.getOrCreate(maxAge);
    }

    public final VoxelShape getBlockShape(Direction facing, int age) {
        return this.blockShapeData.getShapeFor(facing, age);
    }

    public void setBlockShapes(Direction facing, VoxelShape[] blockShapes) {
        this.blockShapeData.setShapesFor(facing, blockShapes);
    }

    public final boolean canBoneMeal() {
        return this.canBoneMeal;
    }

    public void setCanBoneMeal(boolean canBoneMeal) {
        this.canBoneMeal = canBoneMeal;
    }

    public final ItemStack getItemStack() {
        if (this.itemStack == null) {
            throw new IllegalStateException("Invoked too early or item was not set on \"" + this.getRegistryName() + "\".");
        }
        return this.itemStack.func_77946_l();
    }

    public boolean isItem(ItemStack itemStack) {
        return ItemStack.func_77989_b((ItemStack)this.itemStack, (ItemStack)itemStack);
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public final float getGrowthChance() {
        return this.growthChance;
    }

    public void setGrowthChance(float growthChance) {
        this.growthChance = growthChance;
    }

    public boolean isInFlowerHoldPeriod(IWorld world, BlockPos rootPos, Float seasonValue) {
        if (this.seasonOffset == null) {
            return false;
        }
        Float peakSeasonValue = SeasonHelper.getSeasonManager().getPeakFruitProductionSeasonValue(WorldContext.create(world).level(), rootPos, this.seasonOffset.floatValue());
        if (peakSeasonValue == null || this.flowerHoldPeriodLength == 0.0f) {
            return false;
        }
        float min = peakSeasonValue.floatValue() - 1.5f;
        float max = min + this.flowerHoldPeriodLength;
        return SeasonHelper.isSeasonBetween(seasonValue, min, max);
    }

    @Nullable
    public final Float getSeasonOffset() {
        return this.seasonOffset;
    }

    public void setSeasonOffset(@Nullable Float offset) {
        this.seasonOffset = offset;
    }

    public float seasonalProductionFactor(WorldContext worldContext, BlockPos pos) {
        return this.seasonOffset != null ? SeasonHelper.globalSeasonalFruitProductionFactor(worldContext, pos, -this.seasonOffset.floatValue(), false) : 1.0f;
    }

    public float getFlowerHoldPeriodLength() {
        return this.flowerHoldPeriodLength;
    }

    public void setFlowerHoldPeriodLength(float flowerHoldPeriodLength) {
        this.flowerHoldPeriodLength = flowerHoldPeriodLength;
    }

    public final float getMinProductionFactor() {
        return this.minProductionFactor;
    }

    public void setMinProductionFactor(float minProductionFactor) {
        this.minProductionFactor = minProductionFactor;
    }

    public boolean isOutOfSeason(WorldContext worldContext, BlockPos pos) {
        return this.seasonalProductionFactor(worldContext, pos) < this.minProductionFactor;
    }

    public void place(IWorld world, BlockPos pos, @Nullable Float seasonValue, Direction facing) {
        BlockState state = this.getStateFor(facing, 0);
        world.func_180501_a(pos, state, 2);
    }

    public void placeDuringWorldGen(IWorld world, BlockPos pos, @Nullable Float seasonValue, Direction facing) {
        BlockState state = this.getStateFor(facing, this.getAgeForWorldGen(world, pos, seasonValue));
        world.func_180501_a(pos, state, 2);
    }

    protected BlockState getStateFor(Direction facing, int age) {
        if (age < 0) {
            throw new IllegalArgumentException("Cannot get state for negative pod age.");
        }
        if (age > this.maxAge) {
            throw new IllegalArgumentException("Cannot get state for age " + age + " as it is greater than maximum " + this.maxAge + " for pod \"" + this.getRegistryName() + "\".");
        }
        return (BlockState)((BlockState)this.block.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)facing)).func_206870_a((Property)this.ageProperty, (Comparable)Integer.valueOf(age));
    }

    protected int getAgeForWorldGen(IWorld world, BlockPos pos, @Nullable Float seasonValue) {
        if (seasonValue != null && this.isInFlowerHoldPeriod(world, pos, seasonValue)) {
            return 0;
        }
        return Math.min(world.func_201674_k().nextInt(this.maxAge * 2), this.maxAge);
    }

    public void performMatureAction(GrowableBlock.Info blockInfo) {
        this.matureAction.perform(this.block, blockInfo);
    }

    public void setMatureAction(GrowableBlock.MatureAction matureAction) {
        this.matureAction = matureAction;
    }

    public boolean shouldGenerateBlockDrops() {
        return true;
    }

    public ResourceLocation getBlockDropsPath() {
        return this.blockDropsPath.get();
    }

    public LootTable.Builder createBlockDrops() {
        return DTLootTableProvider.createPodDrops((Block)this.block, this.itemStack.func_77973_b(), this.ageProperty, this.maxAge);
    }

    @Override
    @Nonnull
    public Pod reset() {
        this.canBoneMeal = (Boolean)DTConfigs.CAN_BONE_MEAL_PODS.get();
        this.seasonOffset = Float.valueOf(0.0f);
        this.flowerHoldPeriodLength = 0.5f;
        this.minProductionFactor = 0.3f;
        this.matureAction = GrowableBlock.MatureAction.DEFAULT;
        return this;
    }

    public final class BlockShapeData {
        private final Map<Direction, VoxelShape[]> facingShapes = (Map)Util.func_200696_a((Object)Maps.newHashMap(), facingShapes -> {
            facingShapes.put(Direction.NORTH, new VoxelShape[]{VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b()});
            facingShapes.put(Direction.SOUTH, new VoxelShape[]{VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b()});
            facingShapes.put(Direction.WEST, new VoxelShape[]{VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b()});
            facingShapes.put(Direction.EAST, new VoxelShape[]{VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b()});
        });

        public VoxelShape getShapeFor(Direction facing, int age) {
            return this.facingShapes.get(facing)[age];
        }

        public void setShapesFor(Direction facing, VoxelShape[] shapes) {
            if (shapes.length <= Pod.this.maxAge) {
                throw new IllegalArgumentException("Insufficient number of block shapes provided for the maximum age " + Pod.this.maxAge + " on pod " + this);
            }
            this.facingShapes.put(facing, shapes);
        }
    }
}

