/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.poissondisc;

import com.ferreusveritas.dynamictrees.api.worldgen.PoissonDiscProvider;
import com.ferreusveritas.dynamictrees.event.PoissonDiscProviderCreateEvent;
import com.ferreusveritas.dynamictrees.systems.poissondisc.LevelPoissonDiscProvider;
import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.ferreusveritas.dynamictrees.worldgen.BiomeRadiusCoordinator;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class UniversalPoissonDiscProvider {
    private final Map<ResourceLocation, PoissonDiscProvider> providerMap = new ConcurrentHashMap<ResourceLocation, PoissonDiscProvider>();

    protected PoissonDiscProvider createCircleProvider(WorldContext context) {
        BiomeRadiusCoordinator radiusCoordinator = new BiomeRadiusCoordinator(TreeGenerator.getTreeGenerator(), context.dimensionName(), context.access());
        PoissonDiscProviderCreateEvent poissonDiscProviderCreateEvent = new PoissonDiscProviderCreateEvent(context.access(), new LevelPoissonDiscProvider(radiusCoordinator).setSeed(context.seed()));
        MinecraftForge.EVENT_BUS.post((Event)poissonDiscProviderCreateEvent);
        return poissonDiscProviderCreateEvent.getPoissonDiscProvider();
    }

    public PoissonDiscProvider getProvider(WorldContext context) {
        return this.providerMap.computeIfAbsent(context.dimensionName(), k -> this.createCircleProvider(context));
    }

    public List<PoissonDisc> getPoissonDiscs(WorldContext context, ChunkPos chunkPos) {
        PoissonDiscProvider provider = this.getProvider(context);
        return provider.getPoissonDiscs(chunkPos.field_77276_a, 0, chunkPos.field_77275_b);
    }

    public void unloadWorld(ServerWorld world) {
        this.providerMap.remove(world.func_234923_W_().func_240901_a_());
    }

    public void setChunkPoissonData(WorldContext context, ChunkPos chunkPos, byte[] circleData) {
        this.getProvider(context).setChunkPoissonData(chunkPos.field_77276_a, 0, chunkPos.field_77275_b, circleData);
    }

    public byte[] getChunkPoissonData(WorldContext context, ChunkPos chunkPos) {
        return this.getProvider(context).getChunkPoissonData(chunkPos.field_77276_a, 0, chunkPos.field_77275_b);
    }

    public void unloadChunkPoissonData(WorldContext context, ChunkPos chunkPos) {
        this.getProvider(context).unloadChunkPoissonData(chunkPos.field_77276_a, 0, chunkPos.field_77275_b);
    }
}

