/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substances;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.nodemappers.DenuderNode;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.BlockState;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class DenudeSubstance
implements SubstanceEffect {
    @Override
    public boolean apply(World world, BlockPos rootPos) {
        BlockState rootState = world.func_180495_p(rootPos);
        RootyBlock dirt = TreeHelper.getRooty(rootState);
        if (dirt == null) {
            return false;
        }
        Species species = dirt.getSpecies(rootState, (IWorld)world, rootPos);
        Family family = species.getFamily();
        if (!family.hasStrippedBranch()) {
            return false;
        }
        dirt.setFertility(world, rootPos, 0);
        if (world.field_72995_K) {
            TreeHelper.treeParticles(world, rootPos, ParticleTypes.field_239813_am_, 8);
        } else {
            dirt.startAnalysis((IWorld)world, rootPos, new MapSignal(new DenuderNode(species, family)));
        }
        return true;
    }

    @Override
    public String getName() {
        return "denude";
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

