/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substances;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import java.util.function.Supplier;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FertilizeSubstance
implements SubstanceEffect {
    private int amount = 2;
    private boolean displayParticles = true;
    private boolean grow;
    private Supplier<Integer> pulses = () -> 1;

    @Override
    public boolean apply(World world, BlockPos rootPos) {
        RootyBlock dirt = TreeHelper.getRooty(world.func_180495_p(rootPos));
        if (dirt != null && dirt.fertilize(world, rootPos, this.amount) || this.grow) {
            if (this.displayParticles && world.field_72995_K) {
                TreeHelper.treeParticles(world, rootPos, ParticleTypes.field_197632_y, 8);
            } else if (this.grow) {
                int pulses = this.pulses.get();
                for (int i = 0; i < pulses; ++i) {
                    TreeHelper.growPulse(world, rootPos);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "fertilize";
    }

    public FertilizeSubstance setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public FertilizeSubstance setGrow(boolean grow) {
        this.grow = grow;
        return this;
    }

    public FertilizeSubstance setPulses(int pulses) {
        return this.setPulses(() -> pulses);
    }

    public FertilizeSubstance setDisplayParticles(boolean displayParticles) {
        this.displayParticles = displayParticles;
        return this;
    }

    public FertilizeSubstance setPulses(Supplier<Integer> pulses) {
        this.pulses = pulses;
        return this;
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

