/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substances;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.FruitBlock;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.init.DTClient;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeatures.FruitGenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.nodemappers.FindEndsNode;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HarvestSubstance
implements SubstanceEffect {
    private Species species = Species.NULL_SPECIES;
    private final int duration;
    private final int ticksPerParticlePulse;
    private final int ticksPerGrowthPulse;
    private final int growthPulses;
    private final int ticksPerSpawnAttempt;
    private final Set<BlockPos> fruitPositions = Sets.newHashSet();

    public HarvestSubstance() {
        this(1600, 12, 12, 1, 16);
    }

    public HarvestSubstance(int duration, int ticksPerParticlePulse, int ticksPerGrowthPulse, int growthPulses, int ticksPerSpawnAttempt) {
        this.duration = duration;
        this.ticksPerParticlePulse = ticksPerParticlePulse;
        this.ticksPerGrowthPulse = ticksPerGrowthPulse;
        this.growthPulses = growthPulses;
        this.ticksPerSpawnAttempt = ticksPerSpawnAttempt;
    }

    @Override
    public boolean apply(World world, BlockPos rootPos) {
        BlockState rootState = world.func_180495_p(rootPos);
        RootyBlock rootyBlock = TreeHelper.getRooty(rootState);
        if (rootyBlock == null) {
            return false;
        }
        this.species = rootyBlock.getSpecies(rootState, (IWorld)world, rootPos);
        if (!this.species.hasFruits()) {
            return false;
        }
        this.recalculateFruitPositions((IWorld)world, rootPos, rootyBlock);
        return true;
    }

    private void recalculateFruitPositions(IWorld world, BlockPos rootPos, RootyBlock rootyBlock) {
        this.fruitPositions.clear();
        FindEndsNode findEndsNode = new FindEndsNode();
        rootyBlock.startAnalysis(world, rootPos, new MapSignal(findEndsNode));
        findEndsNode.getEnds().forEach(endPos -> BlockPos.func_218281_b((BlockPos)endPos.func_177982_a(-3, -3, -3), (BlockPos)endPos.func_177982_a(3, 3, 3)).forEach(pos -> {
            if (this.isCompatibleFruitBlock(world, (BlockPos)pos)) {
                this.fruitPositions.add(pos.func_185334_h());
            }
        }));
    }

    private boolean isCompatibleFruitBlock(IWorld world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return this.isCompatibleFruitBlock(block);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCompatibleFruitBlock(Block block) {
        if (!(block instanceof FruitBlock)) return false;
        if (!this.species.getFruits().stream().map(Fruit::getBlock).anyMatch(block::equals)) return false;
        return true;
    }

    @Override
    public boolean update(World world, BlockPos rootPos, int deltaTicks, int fertility) {
        if (deltaTicks > this.duration) {
            return false;
        }
        RootyBlock rootyBlock = TreeHelper.getRooty(world.func_180495_p(rootPos));
        if (rootyBlock == null) {
            return false;
        }
        if (world.field_72995_K) {
            if (deltaTicks % this.ticksPerParticlePulse == 0) {
                this.recalculateFruitPositions((IWorld)world, rootPos, rootyBlock);
                this.fruitPositions.forEach(fruitPos -> DTClient.spawnParticles((IWorld)world, ParticleTypes.field_197620_m, fruitPos.func_177958_n(), fruitPos.func_177956_o(), fruitPos.func_177952_p(), 3, world.func_201674_k()));
            }
        } else {
            boolean spawnAttempt;
            boolean growPulse = deltaTicks % this.ticksPerGrowthPulse == 0;
            boolean bl = spawnAttempt = deltaTicks % this.ticksPerSpawnAttempt == 0;
            if (growPulse || spawnAttempt) {
                this.recalculateFruitPositions((IWorld)world, rootPos, rootyBlock);
            }
            if (growPulse) {
                this.fruitPositions.removeIf(fruitPos -> {
                    BlockState state = world.func_180495_p(fruitPos);
                    Block block = state.func_177230_c();
                    if (!this.isCompatibleFruitBlock(block)) {
                        return true;
                    }
                    for (int i = 0; i < this.growthPulses; ++i) {
                        ((FruitBlock)block).doTick(state, world, (BlockPos)fruitPos, world.field_73012_v);
                    }
                    return false;
                });
            }
            if (spawnAttempt) {
                this.species.getGenFeatures().stream().filter(configuration -> configuration.getGenFeature() instanceof FruitGenFeature).forEach(configuration -> configuration.generate(GenFeature.Type.POST_GROW, new PostGrowContext(world, rootPos, this.species, rootPos.func_177972_a(rootyBlock.getTrunkDirection((IBlockReader)world, rootPos)), fertility, true)));
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "harvest";
    }

    @Override
    public boolean isLingering() {
        return true;
    }
}

