/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substances;

import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffect;
import com.ferreusveritas.dynamictrees.systems.substances.GrowthSubstance;
import com.ferreusveritas.dynamictrees.systems.substances.HarvestSubstance;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.Supplier;

public final class LingeringSubstances {
    public static final LinkedHashMap<Class<SubstanceEffect>, Supplier<SubstanceEffect>> LINGERING_SUBSTANCES = new LinkedHashMap();

    public static <S extends SubstanceEffect> void registerLingeringSubstance(Class<S> substanceClass, Supplier<S> substanceSupplier) {
        LINGERING_SUBSTANCES.put(substanceClass, substanceSupplier);
    }

    public static <S extends SubstanceEffect> int indexOf(Class<S> substanceClass) {
        return new ArrayList<Class<SubstanceEffect>>(LINGERING_SUBSTANCES.keySet()).indexOf(substanceClass);
    }

    public static <S extends SubstanceEffect> Supplier<S> fromIndex(int index) {
        return new ArrayList<Supplier<SubstanceEffect>>(LINGERING_SUBSTANCES.values()).get(index);
    }

    static {
        LingeringSubstances.registerLingeringSubstance(GrowthSubstance.class, GrowthSubstance::new);
        LingeringSubstances.registerLingeringSubstance(HarvestSubstance.class, HarvestSubstance::new);
    }
}

