/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substances;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.compat.waila.WailaOther;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.BlockState;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MegaSubstance
implements SubstanceEffect {
    @Override
    public boolean apply(World world, BlockPos rootPos) {
        BlockState blockState = world.func_180495_p(rootPos);
        RootyBlock dirt = TreeHelper.getRooty(blockState);
        Species species = dirt.getSpecies(blockState, (IWorld)world, rootPos);
        Species megaSpecies = species.getMegaSpecies();
        if (megaSpecies.isValid()) {
            int fertility = dirt.getFertility(blockState, (IBlockReader)world, rootPos);
            megaSpecies.placeRootyDirtBlock((IWorld)world, rootPos, fertility);
            blockState = world.func_180495_p(rootPos);
            dirt = TreeHelper.getRooty(blockState);
            if (dirt.getSpecies(blockState, (IWorld)world, rootPos) == megaSpecies) {
                TreeHelper.treeParticles(world, rootPos, ParticleTypes.field_197616_i, 8);
                WailaOther.invalidateWailaPosition();
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return "mega";
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

