/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.substances;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substances.SubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.nodemappers.TransformNode;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.BlockState;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class TransformSubstance
implements SubstanceEffect {
    private final Species toSpecies;

    public TransformSubstance(Species toTree) {
        this.toSpecies = toTree;
    }

    @Override
    public boolean apply(World world, BlockPos rootPos) {
        Species fromSpecies;
        BlockState rootyState = world.func_180495_p(rootPos);
        RootyBlock dirt = TreeHelper.getRooty(rootyState);
        if (dirt != null && this.toSpecies.isValid() && (fromSpecies = dirt.getSpecies(rootyState, (IWorld)world, rootPos)).isTransformable() && fromSpecies != this.toSpecies) {
            if (world.field_72995_K) {
                TreeHelper.treeParticles(world, rootPos, ParticleTypes.field_197629_v, 8);
            } else {
                dirt.startAnalysis((IWorld)world, rootPos, new MapSignal(new TransformNode(fromSpecies, this.toSpecies)));
            }
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "transform";
    }

    @Override
    public boolean isLingering() {
        return false;
    }
}

